<?php
/**
 * Script para atualizar hashes de integridade após modificação autorizada
 * Execute este script APENAS após fazer alterações legítimas nos arquivos protegidos
 * 
 * USAR: php update_integrity.php
 */

define('BASEPATH', true);
define('FCPATH', dirname(__FILE__) . '/');
define('APPPATH', FCPATH . 'app/');

require_once(APPPATH . 'core/Security_check.php');

// Chave de autorização (a mesma definida em Security_check.php)
$secret_key = 'sifpos_2026_secure_' . md5('wpv_modelo');

echo "==================================================\n";
echo "  Sistema de Atualização de Integridade\n";
echo "==================================================\n\n";

// Solicitar confirmação
echo "Este script atualizará os hashes de proteção.\n";
echo "Execute APENAS após fazer modificações autorizadas.\n\n";
echo "Deseja continuar? (s/n): ";

$handle = fopen("php://stdin", "r");
$line = fgets($handle);
fclose($handle);

if (trim(strtolower($line)) !== 's') {
    echo "\nOperação cancelada.\n";
    exit(0);
}

echo "\nAtualizando hashes de integridade...\n";

$result = Security_check::update_integrity($secret_key);

if ($result) {
    echo "✓ Hashes atualizados com sucesso!\n";
    echo "\nArquivos protegidos:\n";
    echo "  - app/controllers/Auth.php\n";
    echo "  - app/core/Security_check.php\n";
    echo "\nO sistema agora aceita as versões atuais destes arquivos.\n";
} else {
    echo "✗ Erro ao atualizar hashes.\n";
}

echo "\n==================================================\n";
