<?php
// taxpayer_proxy.php
// Simple proxy to call MinFin taxpayer API and avoid CORS problems from localhost.
//
// Usage:  GET taxpayer_proxy.php?nif=999999999
// Returns: the JSON returned by MinFin (or an error JSON)
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *'); // loosen if you prefer same-origin only

$nif = isset($_GET['nif']) ? preg_replace('/\D+/', '', $_GET['nif']) : '';

// Basic validation: 9 digits
if (strlen($nif) !== 9) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'NIF inválido. Deve ter 9 dígitos.']);
    exit;
}

$remote = "https://invoice.minfin.gov.ao/commonServer/common/taxpayer/get/" . $nif;

$ch = curl_init($remote);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_CONNECTTIMEOUT => 8,
    CURLOPT_TIMEOUT => 12,
    CURLOPT_SSL_VERIFYHOST => 2,
    CURLOPT_SSL_VERIFYPEER => true,
    CURLOPT_USERAGENT => 'WPV-Modelo/1.0 (+localhost)',
]);

$resp = curl_exec($ch);
$err  = curl_error($ch);
$code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($resp === false) {
    http_response_code(502);
    echo json_encode(['success' => false, 'error' => 'Erro ao contactar API MinFin: ' . $err]);
    exit;
}

http_response_code($code ?: 200);
echo $resp;
