<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <title><?= lang('Conta Corrente') . " | " . $Settings->site_name; ?></title>
        <base href="<?= base_url() ?>"/> 
        <meta http-equiv="cache-control" content="max-age=0"/>
        <meta http-equiv="cache-control" content="no-cache"/>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
        <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
        <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= $assets ?>plugins/font-awesome/css/font-awesome.css" rel="stylesheet" type="text/css" />
      
        <style type="text/css" media="all">
            body { color: #000; }
            #wrapper { max-width:95%; margin: 0 auto; padding-top: 20px; }
            .btn { border-radius: 0; margin-bottom: 2px; }
            .table {
                    border-radius: 3px;
                    border: 1px solid #ddd;
                    font-size: 14px;
                }
         
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }
            .cancelado {
                    display: block;
                    position: absolute;
                    border:#9ABBFD;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    z-index: -1;
                    opacity : 0.1;
                    
                }
            @media print {
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }
            .cancelado {
                    display: block;
                    position: absolute;
                    border:#9ABBFD;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    z-index: -1;
                    opacity : 0.1;
                    
                }
				 body { color: #000; }
            #wrapper { max-width:95%; margin: 0 auto; padding-top: 20px; }
            .btn { border-radius: 0; margin-bottom: 2px; }
            .table {
                    border-radius: 3px;
                    border: 1px solid #ddd;
                    font-size: 10px;
                }
         
            }
        </style>
        
    </head>
    <body >
        <div id="wrapper" >
            <div class="cancelado">
            <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logotipo"  width="90%" class="img-responsive" border="0" />
            </div>
            <div  style="alt" id="receipt-data">
                <div class="text-left">
                    <div id="">
                    <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logo" width="150"  class="img-responsive" border="0">  
                        <br>
                        <?= $Settings->CompanyName; ?>
                        <br>
                        <?= $Settings->TaxRegistrationNumber; ?>
                        <br>
                        <?= $Settings->AddressDetail; ?>
                        <br>
                        <?= $Settings->phone; ?>
                        
                        <br>      
                    </div>
                </div>              
                <div class="row" style="margin-top:10px;">
                    <div class="col-md-12 text-center text-primary">
                        <h4>Extracto de conta Fornecedor:  <?php echo $supplier->name; ?> </h4>
                    </div>
                    <div class="col-md-12">
                        <table class="table"  width="100%">
                            <thead>
                                <tr>
                                    <th bgcolor="#9ABBFD" class="text-center" ><strong>Data</strong></th>
                                    <th bgcolor="#9ABBFD" class="text-center" ><strong>Documento</strong></th>
									<th bgcolor="#9ABBFD" class="text-center"><strong>Desconto</strong></th>
                                    <th bgcolor="#9ABBFD" class="text-center"><strong>Débito</strong></th>
                                    <th bgcolor="#9ABBFD" class="text-center"><strong>Crédito</strong></th>
                                    <th bgcolor="#9ABBFD" class="text-center"><strong>Saldo</strong></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <th colspan="9" class="text-primary">
                                       
                                    </th>
                                </tr>
                                <?php 
                                    $total_GrossTotal=0;
                                    $total_paid=0;
                                ?>
                                <?php foreach($purchases as $key=>$arr){ 
                                    ?>
                                    <?php
                                        $total_GrossTotal  = $total_GrossTotal + $arr->GrossTotal;
                                        $total_paid  = $total_paid + $arr->paid;
                                    ?>
                                    <tr>
                                        <td class="text-center"><?php echo date_format(date_create($arr->date),"d/m/Y");  ?></td>
                                        <td class="text-center"><?php echo $arr->OriginatingON; ?></td>
                                        <td class="text-center">0.00</td>
                                        <td class="text-center"><?php echo number_format($arr->GrossTotal, 2, ".", "."); ?></td>
                                        <td class="text-center"><?php echo number_format($arr->paid, 2, ".", "."); ?></td>
                                        <td class="text-center"><?php echo number_format($arr->GrossTotal - $arr->paid, 2, ".", ".") ; ?></td>
                                    </tr>
                                <?php }?>
                                <tr>
                                    <th class="text-center" colspan="2">Saldo Final</th>
                                    <th class="text-center">0.00</th>
                                    <th class="text-center"><?php echo number_format($total_GrossTotal, 2, ".", "."); ?></th>
                                    <th class="text-center"><?php echo number_format($total_paid, 2, ".", "."); ?></th>
                                    <th class="text-center"><?php echo number_format($total_GrossTotal-$total_paid, 2, ".", "."); ?></th>
                                </tr>
                            </tbody>
                        </table>
                    </div>                    
                </div>                
            </div>
        </div>
    </body>
    <script src="<?php echo base_url(); ?>themes/default/assets/plugins/jQuery/jQuery-2.1.4.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        // $(function(){
        //     window.print();
        // })
    </script>
</html>