<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
  <div class="row">
    <div class="col-xs-12">
      <div class="box box-primary">
        <div class="box-header">
          <h3 class="box-title"><?= lang('enter_info'); ?></h3>
        </div>

        <div class="box-body">
          <?php echo form_open('suppliers/add', 'class="validation"'); ?>

          <div class="row">
            <!-- COL ESQUERDA: apenas NIF -->
            <div class="col-md-6">
              <div class="form-group">
                <label class="control-label" for="cf1"><?= $this->lang->line("NIF"); ?></label>
                <?= form_input('cf1', set_value('cf1'), 'class="form-control input-sm" id="cf1" required="required"'); ?>
              </div>
            </div>

            <!-- COL DIREITA: dados do fornecedor -->
            <div class="col-md-6">
              <div class="form-group">
                <label class="control-label" for="name">Nome</label>
                <?= form_input('name', set_value('name'), 'class="form-control input-sm" id="name"'); ?>
              </div>

              <div class="form-group">
                <label class="control-label" for="email_address">Endereço de e-mail</label>
                <?= form_input('email', set_value('email'), 'class="form-control input-sm" id="email_address"'); ?>
              </div>

              <div class="form-group">
                <label class="control-label" for="phone">Telefone</label>
                <?= form_input('phone', set_value('phone'), 'class="form-control input-sm" id="phone"'); ?>
              </div>

              <div class="form-group">
                <label class="control-label" for="numero">Numero Edifício</label>
                <?= form_input('numero', set_value('numero'), 'class="form-control input-sm" id="numero"'); ?>
              </div>

              <div class="form-group">
                <label class="control-label" for="rua">Rua</label>
                <?= form_input('rua', set_value('rua'), 'class="form-control input-sm" id="rua"'); ?>
              </div>

              <div class="form-group">
                <label class="control-label" for="endereco">Endereço</label>
                <?= form_input('endereco', set_value('endereco'), 'class="form-control input-sm" id="endereco"'); ?>
              </div>

              <div class="form-group">
                <label class="control-label" for="municipio">Município</label>
                <?= form_input('municipio', set_value('municipio'), 'class="form-control input-sm" id="municipio"'); ?>
              </div>

              <div class="form-group">
                <label class="control-label" for="estado">Província</label>
                <?= form_input('estado', set_value('estado'), 'class="form-control input-sm" id="estado"'); ?>
              </div>

              <div class="form-group">
                <label class="control-label" for="Country">País</label>
                <?= form_input('Country', set_value('Country', 'Angola'), 'class="form-control input-sm" id="Country"'); ?>
              </div>

              <div class="form-group">
                <label class="control-label" for="account_id">Id da Conta</label>
                <?= form_input('account_id', set_value('account_id'), 'class="form-control input-sm" id="account_id"'); ?>
              </div>

              <div class="form-group">
                <?= form_submit('add_supplier', lang('add_supplier'), 'id="btn_add_supplier" class="btn btn-primary"'); ?>
                <a href="<?= site_url('suppliers'); ?>" class="btn btn-default"><?= lang('cancel'); ?></a>
              </div>
            </div>
          </div>

          <?php echo form_close(); ?>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Toast plugin (se o seu layout já carrega, pode remover estas 2 linhas) -->
<link rel="stylesheet" href="<?= $assets ?>plugins/jquery-toast-plugin-master/src/jquery.toast.css">
<script src="<?= $assets ?>plugins/jquery-toast-plugin-master/src/jquery.toast.js"></script>

<style>
/* Alguns temas escondem elementos [disabled]; garantimos que o botão continua visível */
button[disabled], input[type=submit][disabled] { display:inline-block !important; opacity:.65; }
</style>

<script>
/*! NIF AutoFill (+toast) — suppliers/add (inclui mapeamento hdjy/hdjv → #numero) */
(function($){
  var ENDPOINT = '<?= site_url('api/taxpayer') ?>';   // ex.: /api/taxpayer?nif=003136359BA034

  function showToast(msg, icon){
    icon = icon || 'info';
    if ($.toast) { $.toast({ text: msg, icon: icon, position: 'top-right', hideAfter: 4000, loader: false }); }
    else if (window.bootbox) { bootbox.alert(msg); }
    else { alert(msg); }
  }

  function token9plus(v){ v=String(v||'').toUpperCase(); var m=v.match(/[0-9]{9}[A-Z0-9]{0,6}/); return m?m[0]:''; }
  function validEmail(e){ return /.+@.+\..+/.test(String(e||'')); }
  function btn(disabled){
    var $btn = $('#btn_add_supplier, input[name="add_supplier"], input[type=submit], button[type=submit]');
    $btn.prop('disabled', !!disabled).show();
  }
  function setVal(sel, val){ if(!val) return; var $el=$(sel); if($el.length){ $el.val(val); } }

  function fill(d){
    // Nome / Email / Telefone
    var nome  = d.companyName || d.gsmc || d.nameAbb || 'Consumidor final';
    var phone = d.lxfs || '';
    var email = validEmail(d.email) ? d.email : '';

    setVal('#name,#supplier_name,#company', nome);
    setVal('#phone,#phone_number,#supplier_phone', phone);
    setVal('#email_address,#email,#supplier_email', email);

    // Endereço
    var addr  = d.addressSbbb || d.nsrdz || '';
    setVal('#bairro,#address', addr);
    setVal('#rua', d.nsrdz || d.addressSbbb || '');
    setVal('#endereco', d.nsrdz || d.addressSbbb || '');

    // País / Cidade / Província
    if (!$('#Country,#country').val()) setVal('#Country,#country', d.country || 'Angola');
    setVal('#cidade,#city', d.city);
    setVal('#estado,#province,#state', d.province);

    // Número do Edifício (pedido): hdjy/hdjv -> #numero
    setVal('#numero, #building_number, #numero_edificio', d.hdjy || d.hdjv || '');
  }

  function lookup(){
    var t = token9plus($('#cf1').val());
    if(!t){ return; }
    btn(true);

    if (t === '999999999'){
      fill({companyName:'Consumidor final', country:'Angola'});
      btn(false);
      return;
    }

    var url = ENDPOINT + (ENDPOINT.indexOf('?')===-1 ? '?' : '&') + 'nif=' + encodeURIComponent(t);
    $.getJSON(url).done(function(resp){
      var ok = resp && resp.success;
      var d  = (resp && (resp.data || resp)) || {};
      if (ok) fill(d); else showToast('NIF não encontrado no MinFin.', 'warning');
    }).fail(function(){
      showToast('Falha ao consultar NIF (rede/API).', 'error');
    }).always(function(){
      btn(false);
    });
  }

  // Dispara ao digitar/perder foco e 1x ao carregar
  $(document).on('input.nifauto change.nifauto blur.nifauto', '#cf1', lookup);
  setTimeout(lookup, 120);

  // Validação simples de e-mail
  $('form').on('submit', function(ev){
    var e = $('#email_address,#email,#supplier_email').val();
    if (e && !validEmail(e)){
      ev.preventDefault();
      showToast('E-mail inválido. Por favor verifique.', 'warning');
    }
  });
})(jQuery);
</script>
