<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('update_info'); ?></h3>
                </div>
                <div class="box-body">
                        <?= form_open_multipart("settings", 'class="validation"'); ?>

                    <div class="col-lg-12">
                        <div class="well well-sm">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("CompanyID", 'CompanyID'); ?>
                                            <?= form_input('CompanyID', $settings->CompanyID, 'class="form-control" id="CompanyID" required="required"'); ?>
                                        </div>
                                    </div>           
                                    
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("CompanyName", 'CompanyName'); ?>
                                            <?= form_input('CompanyName', $settings->CompanyName, 'class="form-control" id="CompanyName" required="required"'); ?>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("BusinessName", 'BusinessName'); ?>
                                            <?= form_input('BusinessName', $settings->BusinessName, 'class="form-control" id="BusinessName" required="required"'); ?>
                                        </div>
                                    </div>

                                    <?= lang("TaxRegistrationNumber", 'TaxRegistrationNumber'); ?>

                                    <div class="input-group">
                                        <?= form_input('TaxRegistrationNumber', $settings->TaxRegistrationNumber, 'class="form-control" id="TaxRegistrationNumber" required="required"'); ?>

                                        <span class="input-group-btn">
                                            <button type="button" class="btn btn-info" id="btnConsultarNif" title="Pesquisar NIF">
                                                <i class="fa fa-search"></i>
                                            </button>
                                        </span>
                                    </div>

                                    <small class="text-muted" style="display:block;margin-top:6px;">
                                        Clique na lupa para buscar os dados do contribuinte.
                                    </small>


                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("TaxAccountingBasis", 'TaxAccountingBasis'); ?>
                                            <?= form_input('TaxAccountingBasis', $settings->TaxAccountingBasis, 'class="form-control" id="TaxAccountingBasis" required="required"  readonly'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("FiscalYear", 'FiscalYear'); ?>
                                            <?= form_input('FiscalYear', $settings->FiscalYear, 'class="form-control" id="FiscalYear" required="required"'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("CurrencyCode", 'CurrencyCode'); ?>
                                            <?= form_input('CurrencyCode', $settings->CurrencyCode, 'class="form-control" id="CurrencyCode" required="required"'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="form-group">
                                            <?= lang("Tipo de Faturação", 'tipo_faturacao'); ?>
                                            <?php
                                            $tipo_fat_options = array(
                                                'Faturação Eletronica' => 'Faturação Eletronica',
                                                'SAF-T AO' => 'SAF-T AO'
                                            );
                                            $tipo_faturacao_value = isset($settings->tipo_faturacao) ? $settings->tipo_faturacao : 'Faturação Eletronica';
                                            echo form_dropdown('tipo_faturacao', $tipo_fat_options, $tipo_faturacao_value, 'class="form-control select2" id="tipo_faturacao" style="width:100%;" required="required"');
                                            ?>
                                        </div>
                                    </div>
                                    
                                    <div class="form-group">
                                    
                                    <?= lang('TaxEntity', 'TaxEntity') ?>
                                    <?php
                                    $rw = array('Regime Geral' => 'Regime Geral', 'Regime Simplificado' => 'Regime Simplificado', 'IVA – Regime de Exclusão' => 'IVA – Regime de Exclusão');
                                    echo form_dropdown('regime', $rw, $settings->regime, 'class="form-control select2" id="regime" style="width:100%;" required="required"') ?>
                                        </div>
                                    
                                   
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("Entidade Fiscal", 'Entidade Fiscal'); ?>
                                            <?= form_input('TaxEntity', $settings->TaxEntity, 'class="form-control" id="TaxEntity" required="required"'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group" id="grupo-private">
                                       <div class="form-group">
                                            <?= lang("private", 'private'); ?>
                                            <?= form_input('private', $settings->private, 'class="form-control" id="private" required="required"  '); ?>
                                        </div>
                                    </div>
                                    <div class="form-group" id="grupo-public">
                                       <div class="form-group">
                                            <?= lang("public", 'public'); ?>
                                            <?= form_input('public', $settings->public, 'class="form-control" id="public" required="required"  '); ?>
                                        </div>
                                    </div>
                                    <div style="margin-top:8px;" id="grupo-diagnostico">
    <a href="<?= base_url('diagnostico_chave_cliente.php') ?>"
       target="_blank"
       class="btn btn-warning btn-sm">
        <i class="fa fa-stethoscope"></i> Diagnóstico Chave Cliente
    </a>
</div>

                                    <div class="form-group" id="grupo-software-validation">
                                       <div class="form-group">
                                            <?= lang("SoftwareValidationNumber", 'SoftwareValidationNumber'); ?>
                                            <?= form_input('SoftwareValidationNumber', $settings->SoftwareValidationNumber, 'class="form-control" id="SoftwareValidationNumber" required="required" readonly'); ?>
                                        </div>
                                    </div>
                                     <div class="form-group" id="grupo-series-agt">
                                       <div class="form-group">
                                        <div class="form-group">
                                        <label style="display:block;">Séries AGT</label>
                                        
                                        <div class="form-group">
                                            <label for="establishmentNumber">Número do Estabelecimento:</label>
                                            <?= form_input('establishmentNumber', isset($settings->envato_username) && !empty($settings->envato_username) ? $settings->envato_username : 'SEDE', 'class="form-control" id="establishmentNumber" placeholder="Ex: SEDE, 10, 20..."'); ?>
                                            <small class="text-muted" style="display:block;margin-top:3px;">
                                                Indique o número do estabelecimento (ex: SEDE, 10, 20, etc.). Será usado ao criar as séries na AGT.
                                            </small>
                                        </div>
                                        
                                        <?php if ($this->Super_admin) { ?>
                                        <button type="button" class="btn btn-primary" id="btnConsultarSeries" title="Consultar séries na AGT e guardar">
                                            <i class="fa fa-refresh"></i> Consultar Séries (AGT) e Guardar
                                        </button>
                                        <?php } ?>

                                        <small class="text-muted" style="display:block;margin-top:6px;">
                                            Clica aqui para buscar as séries (FT/FR/GF/NC/RC) e gravar automaticamente nas Settings.
                                        </small>
                                    </div>
                                            <?= lang("FT-seriesCode", 'FT-seriesCode'); ?>
                                            <?= form_input('FT-seriesCode', $settings->{'FT-seriesCode'}, 'class="form-control" id="FT-seriesCode" required="required" '); ?>
                                        </div>
                                    </div> 
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("FR-seriesCode", 'FR-seriesCode'); ?>
                                            <?= form_input('FR-seriesCode', $settings->{'FR-seriesCode'}, 'class="form-control" id="FR-seriesCode" required="required" '); ?>
                                        </div>
                                    </div> 
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("GF-seriesCode", 'GF-seriesCode'); ?>
                                            <?= form_input('GF-seriesCode', $settings->{'GF-seriesCode'}, 'class="form-control" id="GF-seriesCode" required="required" '); ?>
                                        </div>
                                    </div> 
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("NC-seriesCode", 'NC-seriesCode'); ?>
                                            <?= form_input('NC-seriesCode', $settings->{'NC-seriesCode'}, 'class="form-control" id="NC-seriesCode" required="required" '); ?>
                                        </div>
                                    </div> 
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("RC-seriesCode", 'RC-seriesCode'); ?>
                                            <?= form_input('RC-seriesCode', $settings->{'RC-seriesCode'}, 'class="form-control" id="RC-seriesCode" required="required" '); ?>
                                        </div>
                                    </div> 
                                   

                                </div>

                                <div class="col-md-6">
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("BuildingNumber", 'BuildingNumber'); ?>
                                            <?= form_input('BuildingNumber', $settings->BuildingNumber, 'class="form-control" id="BuildingNumber"'); ?>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("StreetName", 'StreetName'); ?>
                                            <?= form_input('StreetName', $settings->StreetName, 'class="form-control" id="StreetName" '); ?>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("AddressDetail", 'AddressDetail'); ?>
                                            <?= form_input('AddressDetail', $settings->AddressDetail, 'class="form-control" id="AddressDetail" required="required"'); ?>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("City", 'City'); ?>
                                            <?= form_input('City', $settings->City, 'class="form-control" id="City" required="required"'); ?>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("PostalCode", 'PostalCode'); ?>
                                            <?= form_input('PostalCode', $settings->PostalCode, 'class="form-control" id="PostalCode" '); ?>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("Province", 'Province'); ?>
                                            <?= form_input('Province', $settings->Province, 'class="form-control" id="Province" '); ?>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("Fax", 'Fax'); ?>
                                            <?= form_input('Fax', $settings->Fax, 'class="form-control" id="Fax" '); ?>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("Email", 'Email'); ?>
                                            <?= form_input('Email', $settings->Email, 'class="form-control" id="Email" '); ?>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("Website", 'Website'); ?>
                                            <?= form_input('Website', $settings->Website, 'class="form-control" id="Website" '); ?>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("Phone", 'phone'); ?>
                                            <?= form_input('phone', $settings->phone, 'class="form-control" id="phone" '); ?>
                                        </div>
                                    </div>
                                    <?php if ($Admin) { ?>
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("Licença", 'Licença'); ?>
                                            
                                            <?= form_input('licence', $settings->licence, 'class="form-control" id="licence" '); ?>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    <?php if ($Admin) { ?>
                                    <div class="form-group">
                                       <div class="form-group">
                                            <?= lang("Data Licença", 'Data Licença'); ?> Expira em: <?= base64_decode($Settings->expired_month)?>
                                            <?php  if(base64_decode($Settings->expired_month) >= date('Y-m-d'))
                                            echo form_input('expired_month', ($Settings->expired_month), 'class="form-control" id="expired_month" readonly');
                                             else 
                                            echo form_input('expired_month', ($Settings->expired_month), 'class="form-control" id="expired_month"');  

                                             ?>
                                            
                                       </div>
                                    </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-12">
                        <div class="row">
                            <div class="col-md-6">
                                
                               
                                <div class="form-group">
                                    <?= lang('language', 'language'); ?>
                                    <?php $available_langs = array(
                                        'portugues' => 'portugues',
                                        'english' => 'English'
                                    ); ?>
                                    <?= form_dropdown('language', $available_langs, $settings->language, 'class="form-control tip select2" id="language"  required="required" style="width:100%;"'); ?>
                                </div>
                               

                                <div class="form-group">
                                    <?= lang("default_discount", 'default_discount'); ?>
                                    <?= form_input('default_discount', $settings->default_discount, 'class="form-control" id="default_discount" required="required"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang("default_order_tax", 'default_tax_rate'); ?>
                                    <?= form_input('tax_rate', $settings->default_tax_rate, 'class="form-control" id="default_tax_rate" required="required"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('row_per_page', 'rows_per_page') ?>
                                    <?php
                                    $rw = array('10' => '10', '25' => '25', '50' => '50', '100' => '100');
                                    echo form_dropdown('rows_per_page', $rw, $settings->rows_per_page, 'class="form-control select2" id="rows_per_page" style="width:100%;" required="required"') ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('rounding', 'rounding'); ?>
                                    <?php
                                    $rnd = array('0' => lang('disable'), '1' => lang('to_nearest_005'), '2' => lang('to_nearest_050'), '3' => lang('to_nearest_number'), '4' => lang('to_next_number'));
                                    echo form_dropdown('rounding', $rnd, $settings->rounding, 'class="form-control select2" id="rounding" required="required"');
                                    ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('display_product', 'display_product') ?>
                                    <?php
                                    $dprv = array('1' => 'Name', '2' => 'Photo', '3' => 'Both');
                                    echo form_dropdown('display_product', $dprv, $settings->bsty, 'class="form-control select2" id="display_product" style="width:100%;" required="required"') ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('pro_limit', 'pro_limit') ?>
                                    <?= form_input('pro_limit', $settings->pro_limit, 'class="form-control" id="pro_limit" required="required"') ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('default_email', 'default_email'); ?>
                                    <?= form_input('default_email', $settings->default_email, 'class="form-control tip" id="default_email" required="required"'); ?>
                                </div>

                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('delete_code', 'pin_code'); ?>
                                    <?php echo form_password('pin_code', $settings->pin_code, 'class="form-control" pattern="[0-9]{4,8}"id="pin_code"'); ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('display_kb', 'display_kb') ?>
                                    <?php
                                    $dtime = array('1' => lang('yes'), '0' => lang('no'));
                                    echo form_dropdown('display_kb', $dtime, $settings->display_kb, 'class="form-control select2" id="display_kb" style="width:100%;" required="required"') ?>
                                </div>
                                <div class="form-group">
                                    <?= lang("item_addition", "item_addition"); ?>
                                    <?php
                                    $ia = array(0 => lang('add_new_item'), 1 => lang('increase_quantity_if_item_exist'));
                                    echo form_dropdown('item_addition', $ia, $Settings->item_addition, 'id="item_addition" class="form-control tip select2" required="required" style="width:100%;"');
                                    ?>
                                </div>
                                <div class="form-group">
                                    <?= lang('default_category', 'default_category') ?>
                                    <?php
                                    foreach ($categories as $catrgory) {
                                        $ct[$catrgory->id] = $catrgory->name;
                                    }
                                    echo form_dropdown('default_category', $ct, $settings->default_category, 'class="form-control select2" style="width:100%;" id="default_category" required="required"') ?>
                                </div>

                                <div class="form-group">
                                    <?= lang("default_customer", 'default_customer'); ?>
                                    <?php
                                    foreach ($customers as $customer) {
                                        $cu[$customer->id] = $customer->name;
                                    }
                                    echo form_dropdown('default_customer', $cu, $settings->default_customer, 'class="form-control select2" style="width:100%;" id="default_customer" required="required"'); ?>
                                </div>

                                <div class="form-group">
                                    <div class="form-group">
                                        <?= lang('dateformat', 'dateformat'); ?> <a href="http://php.net/manual/en/function.date.php" target="_blank"><i class="fa fa-external-link"></i></a>
                                        <?= form_input('dateformat', $settings->dateformat, 'class="form-control tip" id="dateformat"  required="required"'); ?>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <?= lang('timeformat', 'timeformat'); ?>
                                    <?= form_input('timeformat', $settings->timeformat, 'class="form-control tip" id="timeformat"  required="required"'); ?>
                                </div>

                                

                                <div class="form-group">
                                    <?= lang("email_protocol", 'protocol'); ?>
                                    <div class="controls">
                                        <?php
                                        $popt = array('mail' => 'PHP Mail Function', 'sendmail' => 'Send Mail', 'smtp' => 'SMTP');
                                        echo form_dropdown('protocol', $popt, $Settings->protocol, 'class="form-control tip select2" id="protocol" style="width:100%;" required="required"');
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row" id="sendmail_config" style="display: none;">
                                <div class="col-md-12">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <?= lang("mailpath", 'mailpath'); ?>
                                            <div class="controls"> <?php echo form_input('mailpath', $Settings->mailpath, 'class="form-control tip" id="mailpath"'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="clearfix"></div>
                            <div class="row" id="smtp_config" style="display: none;">
                                <div class="col-md-12">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <?= lang("smtp_host", 'smtp_host'); ?>
                                            <div class="controls"> <?php echo form_input('smtp_host', $Settings->smtp_host, 'class="form-control tip" id="smtp_host"'); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <?= lang("smtp_user", 'smtp_user'); ?>
                                            <div class="controls"> <?php echo form_input('smtp_user', $Settings->smtp_user, 'class="form-control tip" id="smtp_user"'); ?> </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <?= lang("smtp_pass", 'smtp_pass'); ?>
                                            <div class="controls"> <?php echo form_password('smtp_pass', $smtp_pass, 'class="form-control tip" id="smtp_pass"'); ?> </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <?= lang("smtp_port", 'smtp_port'); ?>
                                            <div class="controls"> <?php echo form_input('smtp_port', $Settings->smtp_port, 'class="form-control tip" id="smtp_port"'); ?> </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <?= lang("smtp_crypto", 'smtp_crypto'); ?>
                                            <?php
                                            $crypto_opt = array('' => lang('none'), 'tls' => 'TLS', 'ssl' => 'SSL');
                                            echo form_dropdown('smtp_crypto', $crypto_opt, $Settings->smtp_crypto, 'class="form-control tip select2" id="smtp_crypto" style="width:100%;"');
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="well well-sm">
                                    <div class="col-md-6 col-sm-6">
                                        <div class="form-group">
                                            <?= lang('enable_java_applet', 'enable_java_applet'); ?>
                                            <?php $yn = array('1' => lang('yes'), '0' => lang('no')); ?>
                                            <?= form_dropdown('enable_java_applet', $yn, $Settings->java_applet, 'class="form-control select2" id="enable_java_applet" required="required" style="width:100%;"');
                                            ?>
                                        </div>
                                    </div>
                                    <div class="clearfix"></div>
                                    <div id="jac" class="col-md-12" style="display: none;">
                                        <div class="row">
                                            <div class="col-md-3 col-sm-3">
                                                <div class="form-group">
                                                    <?= lang('receipt_printer', 'rec1'); ?>
                                                    <?php echo form_input('receipt_printer', $Settings->receipt_printer, 'class="form-control tip" id="rec1"'); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-sm-3">
                                                <div class="form-group">
                                                    <?= lang('char_per_line', 'char_per_line'); ?>
                                                    <?php echo form_input('char_per_line', $Settings->char_per_line, 'class="form-control tip" id="char_per_line" placeholder="' . lang('char_per_line') . '"'); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-3 col-sm-3">
                                                <div class="form-group">
                                                    <?= lang('cash_drawer_codes', 'cash1'); ?>
                                                    <?php echo form_input('cash_drawer_codes', $Settings->cash_drawer_codes, 'class="form-control tip" id="cash1" placeholder="Hex value (x1C)"'); ?>
                                                </div>
                                            </div>

                                            <div class="col-md-3 col-sm-3">
                                                <div class="form-group">
                                                    <?= lang('pos_list_printers', 'pos_printers'); ?>
                                                    <?php echo form_input('pos_printers', $Settings->pos_printers, 'class="form-control tip" id="pos_printers"'); ?>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>
                                        <div class="well well-sm">
                                            <p>Please add <strong><?= base_url() ?></strong> to your java Exception Site List under
                                                Security tab.</p>

                                                <p><strong>Access Java Control Panel</strong></p>
                                                <pre><strong>Windows:</strong> Control Panel > (Java Icon) Java > Security tab > Exception Site List > Edit Site List > add<br><strong>Mac:</strong> System Preferences > (Java Icon) Java > Security tab > Exception Site List > Edit Site List > add</pre>
                                            </div>
                                        </div>
                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            </div>
                           
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <?= lang('Logo', 'Logo'); ?>
                                        <input type="file" name="userfile" id="logo">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                            <div class="form-group">
                                            <?= lang('Largura do Logo', 'Largura do Logo'); ?>
                                                <?php echo form_input('cancel_sale', $Settings->cancel_sale, 'class="form-control tip" id="cancel_sale"'); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                            <?= lang('Altura do Logo', 'Altura'); ?>
                                                <?php echo form_input('suspend_sale', $Settings->suspend_sale, 'class="form-control tip" id="suspend_sale"'); ?>
                                            </div>
                                        </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?= lang("bill_header", 'bill_header'); ?>
                                        <?= form_textarea('bill_header', $settings->header, 'class="form-control redactor" id="bill_header"'); ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <?= lang("bill_footer", 'bill_footer'); ?>
                                        <?= form_textarea('bill_footer', $settings->footer, 'class="form-control redactor" id="bill_footer"'); ?>
                                    </div>
                                </div>
                            </div>
                            <?= form_submit('update', lang('update_settings'), 'class="btn btn-primary"'); ?>
                            <?= form_close(); ?>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <script type="text/javascript">
        $(document).ready(function() {
            if ($('#protocol').val() == 'smtp') {
                $('#smtp_config').slideDown();
            } else if ($('#protocol').val() == 'sendmail') {
                $('#sendmail_config').slideDown();
            }
            $('#protocol').change(function () {
                if ($(this).val() == 'smtp') {
                    $('#sendmail_config').slideUp();
                    $('#smtp_config').slideDown();
                } else if ($(this).val() == 'sendmail') {
                    $('#smtp_config').slideUp();
                    $('#sendmail_config').slideDown();
                } else {
                    $('#smtp_config').slideUp();
                    $('#sendmail_config').slideUp();
                }
            });
            if ($('#stripe').val() == 0) {
                $('#stripe_con').slideUp();
            } else {
                $('#stripe_con').slideDown();
            }
            $('#stripe').change(function () {
                if ($(this).val() == 0) {
                    $('#stripe_con').slideUp();
                } else {
                    $('#stripe_con').slideDown();
                }
            });

            $('#enable_java_applet').change(function () {
                var ja = $(this).val();
                if (ja == 1) {
                    $('#jac').slideDown();
                } else {
                    $('#jac').slideUp();
                }
            });
            var ja = '<?=$Settings->java_applet?>';
            if (ja == 1) {
                $('#jac').slideDown();
            } else {
                $('#jac').slideUp();
            }
        });
    </script>
<!-- Toast plugin (igual ao add.php) -->
<link rel="stylesheet" href="<?= $assets ?>plugins/jquery-toast-plugin-master/src/jquery.toast.css">
<script src="<?= $assets ?>plugins/jquery-toast-plugin-master/src/jquery.toast.js"></script>

<script>
/**
 * Auto-preenchimento da EMPRESA (Settings) a partir do NIF
 * Usa o endpoint: /api/consultar-nif/{nif}
 * (mesmo padrão do add.php)
 */
(function($){
    var ENDPOINT = '<?= site_url("api/consultar-nif") ?>';
    var DEBUG    = true;
    var isConsultingNif = false;

    function log() {
        if (DEBUG && window.console && console.log) {
            console.log.apply(console, ['[NIF-AutoFill-SETTINGS]'].concat([].slice.call(arguments)));
        }
    }

    function showToast(msg, icon) {
        icon = icon || 'info';
        if ($.toast) {
            $.toast({
                text: msg,
                icon: icon,
                position: 'top-right',
                hideAfter: 4000,
                loader: false
            });
        } else if (window.bootbox) {
            bootbox.alert(msg);
        } else {
            alert(msg);
        }
    }

    function normalizarDocumento(str) {
        return String(str || '').trim();
    }

    function setVal(selector, value) {
        if (value === undefined || value === null || value === '') return;
        var $el = $(selector);
        if ($el.length) $el.val(value);
    }

    function toggleSubmit(disabled) {
        $('input[name="update"], input[type=submit], button[type=submit]')
            .prop('disabled', !!disabled);
    }

    /**
     * Mapeamento: resposta da API -> campos do Settings
     * Ajustei para os IDs que tens na tua view.
     */
    function fillSettings(data) {
        // Nome / Razão Social
        // (na API pode vir como name OU company)
        var nome = data.name || data.company || '';

        setVal('#CompanyName',  nome || $('#CompanyName').val());
        setVal('#BusinessName', nome || $('#BusinessName').val());

        // Endereço
        setVal('#AddressDetail', data.address || $('#AddressDetail').val());

        // Cidade / Província
        setVal('#City',      data.city  || $('#City').val());
        setVal('#Province',  data.state || $('#Province').val());

        // Contactos
        setVal('#Email', data.email || $('#Email').val());
        setVal('#phone', data.phone || $('#phone').val());

        // Campo extra se quiseres usar CAE como “BuildingNumber” (opcional)
        // No add.php vocês estavam a usar "CAE" num input.
        // Se a API devolver "cae", preenche aqui:
        setVal('#BuildingNumber', data.cae || $('#BuildingNumber').val());

        // Se a tua API devolver "number" (nº porta/prédio), também dá para usar
        if (data.number) {
            setVal('#BuildingNumber', data.number);
        }

        log('Campos do settings preenchidos a partir do NIF', data);
    }

    function consultarNifSettings() {
        var nif = normalizarDocumento($('#TaxRegistrationNumber').val());

        // validação mínima
        if (!nif || nif.length < 9) return;

        // evita chamadas duplicadas
        if (isConsultingNif) return;

        // NIF consumidor final (se quiseres tratar igual ao add.php)
        if (nif === '999999999') {
            fillSettings({
                name: 'Consumidor Final',
                company: 'Consumidor Final'
            });
            return;
        }

        var url = ENDPOINT + '/' + encodeURIComponent(nif);
        log('GET', url);

        isConsultingNif = true;
        toggleSubmit(true);
        showToast('A consultar NIF na AGT...', 'info');

        $.getJSON(url)
            .done(function(resp){
                if (resp && resp.success) {
                    fillSettings(resp);
                    showToast('Dados do contribuinte carregados com sucesso.', 'success');
                } else {
                    var msg = (resp && resp.message) ? resp.message : 'Contribuinte não encontrado na AGT.';
                    showToast(msg, 'warning');
                }
            })
            .fail(function(jqXHR, textStatus){
                log('Erro na chamada AJAX', textStatus, jqXHR);
                showToast('Falha ao consultar NIF (rede ou API).', 'error');
            })
            .always(function(){
                isConsultingNif = false;
                toggleSubmit(false);
            });
    }
   

})(jQuery);

// ====== CONSULTAR NIF AO CLICAR NO BOTÃO (não no blur) ======
var ENDPOINT_NIF = '<?= site_url("api/consultar-nif") ?>';
var nifLoading = false;

function normalizarDocumento(v){ return String(v || '').trim(); }

function toggleNifBtn(disabled){
    $('#btnConsultarNif').prop('disabled', !!disabled);
    $('#TaxRegistrationNumber').prop('readonly', !!disabled);
}

function setVal(sel, val){
    if (val === undefined || val === null || val === '') return;
    var $el = $(sel);
    if ($el.length) $el.val(val);
}

function fillSettingsFromNif(data){
    // Ajusta conforme o JSON do teu endpoint
    var nome = data.name || data.company || '';

    setVal('#CompanyName', nome);
    setVal('#BusinessName', nome);

    setVal('#AddressDetail', data.address);
    setVal('#StreetName', data.street || data.addressLine || ''); // se existir na API
    setVal('#City', data.city);
    setVal('#Province', data.state);

    setVal('#Email', data.email);
    setVal('#phone', data.phone);

    // CAE (no teu ecrã tens um campo “CAE”)
    setVal('#BuildingNumber', data.cae); // se quiseres usar noutro campo
    // Se tens um input próprio para CAE, mete aqui o ID correcto:
    // setVal('#CAE', data.cae);
}

function consultarNifSettings(){
    var nif = normalizarDocumento($('#TaxRegistrationNumber').val());

    if (!nif || nif.length < 9){
        $.toast && $.toast({text:'Informe um NIF válido.', icon:'warning', position:'top-right', hideAfter:3000, loader:false});
        return;
    }

    if (nifLoading) return;

    nifLoading = true;
    toggleNifBtn(true);

    // feedback visual
    var $btn = $('#btnConsultarNif');
    var oldHtml = $btn.html();
    $btn.html('<i class="fa fa-spinner fa-spin"></i>');

    $.getJSON(ENDPOINT_NIF + '/' + encodeURIComponent(nif))
        .done(function(resp){
            if (resp && resp.success){
                fillSettingsFromNif(resp);
                $.toast && $.toast({text:'Dados carregados com sucesso.', icon:'success', position:'top-right', hideAfter:3500, loader:false});
            } else {
                var msg = (resp && resp.message) ? resp.message : 'Contribuinte não encontrado.';
                $.toast && $.toast({text: msg, icon:'warning', position:'top-right', hideAfter:4000, loader:false});
            }
        })
        .fail(function(){
            $.toast && $.toast({text:'Falha ao consultar NIF (API/rede).', icon:'error', position:'top-right', hideAfter:4500, loader:false});
        })
        .always(function(){
            nifLoading = false;
            toggleNifBtn(false);
            $btn.html(oldHtml);
        });
}

// click no botão
$(document).on('click', '#btnConsultarNif', function(){
    consultarNifSettings();
});



</script>
<script>
var ENDPOINT_SERIES = '<?= site_url("agt/listar_series") ?>';
var seriesLoading = false;

function toggleSeriesBtn(disabled){
    $('#btnConsultarSeries').prop('disabled', !!disabled);
}

function getEstablishmentNumber(){
    // Ler o número do estabelecimento do campo input
    var est = $.trim($('#establishmentNumber').val() || 'SEDE');
    return est === '' ? 'SEDE' : est;
}

function fillSeriesFromAgt(resp){
    console.log('fillSeriesFromAgt recebeu:', resp);
    
    if (!resp || !resp.uniqueByType) {
        console.warn('Resposta sem uniqueByType:', resp);
        return;
    }

    var u = resp.uniqueByType;
    console.log('uniqueByType:', u);

    if (u.FT && u.FT.seriesCode) {
        console.log('Preenchendo FT com:', u.FT.seriesCode);
        $('#FT-seriesCode').val(u.FT.seriesCode);
    }
    if (u.FR && u.FR.seriesCode) {
        console.log('Preenchendo FR com:', u.FR.seriesCode);
        $('#FR-seriesCode').val(u.FR.seriesCode);
    }
    if (u.GF && u.GF.seriesCode) {
        console.log('Preenchendo GF com:', u.GF.seriesCode);
        $('#GF-seriesCode').val(u.GF.seriesCode);
    }
    if (u.NC && u.NC.seriesCode) {
        console.log('Preenchendo NC com:', u.NC.seriesCode);
        $('#NC-seriesCode').val(u.NC.seriesCode);
    }
    if (u.RC && u.RC.seriesCode) {
        console.log('Preenchendo RC com:', u.RC.seriesCode);
        $('#RC-seriesCode').val(u.RC.seriesCode);
    }
}

function seriesJaExistemNaDB(){
    // se pelo menos FT e NC existirem, já consideramos “configurado”
    // (podes endurecer: exigir todos os 5)
    var ft = $.trim($('#FT-seriesCode').val() || '');
    var nc = $.trim($('#NC-seriesCode').val() || '');    // Ignorar "NULL" como valor válido
    if (ft === 'NULL') ft = '';
    if (nc === 'NULL') nc = '';    return (ft !== '' || nc !== '');
}

function consultarSeriesAgt(){
    if (seriesLoading) return;

    var jaExiste = seriesJaExistemNaDB();

    if (!jaExiste && confirm('As séries não existem na BD. Deseja criar automaticamente as séries na AGT primeiro?')) {
        // Primeiro descobrir qual establishmentNumber existe
        descobrirEstabelecimento();
        return;
    }

    listarSeriesAgt();
}

function descobrirEstabelecimento(){
    seriesLoading = true;
    toggleSeriesBtn(true);

    var $btn = $('#btnConsultarSeries');
    var oldHtml = $btn.html();
    $btn.html('<i class="fa fa-spinner fa-spin"></i> A verificar estabelecimentos...');

    // Listar séries SEM filtro de establishmentNumber para ver todos
    $.getJSON(ENDPOINT_SERIES, {
        send: 1
        // sem establishmentNumber - lista todos
    })
    .done(function(resp){
        console.log('Descobrir estabelecimento:', resp);
        
        var estabelecimentos = [];
        
        // Extrair establishmentNumber das séries retornadas
        if (resp && resp.agt && resp.agt.json && resp.agt.json.seriesInfo) {
            resp.agt.json.seriesInfo.forEach(function(s){
                if (s.establishmentNumber && estabelecimentos.indexOf(s.establishmentNumber) === -1) {
                    estabelecimentos.push(s.establishmentNumber);
                }
            });
        }
        
        console.log('Estabelecimentos encontrados:', estabelecimentos);
        
        if (estabelecimentos.length > 0) {
            // Usar o primeiro estabelecimento encontrado
            $('#establishmentNumber').val(estabelecimentos[0]);
            $.toast && $.toast({
                text: 'Estabelecimento ' + estabelecimentos[0] + ' detectado. A criar séries...',
                icon:'info',
                position:'top-right',
                hideAfter:2000,
                loader:false
            });
            
            setTimeout(function(){
                criarTodasSeriesAgt();
            }, 500);
        } else {
            // Nenhuma série existe - pedir ao utilizador
            seriesLoading = false;
            toggleSeriesBtn(false);
            $btn.html(oldHtml);
            
            // Usar estabelecimento do campo e tentar criar as séries
            $.toast && $.toast({
                text: 'Nenhuma série encontrada. A tentar criar com estabelecimento "' + getEstablishmentNumber() + '"...',
                icon:'info',
                position:'top-right',
                hideAfter:3000,
                loader:false
            });
            
            console.log('Usar establishmentNumber:', getEstablishmentNumber());
            setTimeout(function(){
                criarTodasSeriesAgt();
            }, 500);
        }
    })
    .fail(function(){
        $.toast && $.toast({text:'Erro ao verificar estabelecimentos.', icon:'error', position:'top-right', hideAfter:3500, loader:false});
        seriesLoading = false;
        toggleSeriesBtn(false);
        $btn.html(oldHtml);
    });
}

function criarTodasSeriesAgt(){
    if (seriesLoading) return;

    seriesLoading = true;
    toggleSeriesBtn(true);

    var $btn = $('#btnConsultarSeries');
    var oldHtml = $btn.html();
    $btn.html('<i class="fa fa-spinner fa-spin"></i> A criar séries na AGT...');

    $.getJSON('<?= site_url("agt/criar_todas_series") ?>', {
        send: 1,
        seriesYear: '<?= date("Y") ?>',
        establishmentNumber: getEstablishmentNumber()
    })
    .done(function(resp){
        console.log('Resposta criar_todas_series:', resp);
        
        if (resp && resp.sucessos > 0){
            $.toast && $.toast({
                text: resp.sucessos + ' séries criadas! A consultar...',
                icon:'success',
                position:'top-right',
                hideAfter:2000,
                loader:false
            });
            
            // Aguardar 2 segundos e depois listar
            setTimeout(function(){
                listarSeriesAgt();
            }, 2000);
        } else if (resp && resp.erros === 5 && resp.resultados) {
            // Todas falharam - verificar se é problema de estabelecimento
            var ft = resp.resultados.FT;
            if (ft && ft.response && ft.response.errorList && ft.response.errorList[0]) {
                var erro = ft.response.errorList[0];
                if (erro.descriptionError && erro.descriptionError.indexOf('estabelecimento') !== -1) {
                    // Erro de estabelecimento não registado
                    $.toast && $.toast({
                        text: 'ATENÇÃO: Nenhum estabelecimento registado na AGT!',
                        icon:'error',
                        position:'top-right',
                        hideAfter:8000,
                        loader:false
                    });
                    
                    alert('❌ ESTABELECIMENTO NÃO REGISTADO NA AGT\n\n' +
                          'Antes de criar séries, precisa:\n\n' +
                          '1. Aceder ao portal da AGT (https://sifp.minfin.gov.ao)\n' +
                          '2. Registar um estabelecimento (normalmente nº 10 para sede)\n' +
                          '3. Voltar aqui e tentar novamente\n\n' +
                          'OU\n\n' +
                          'Preencha manualmente os campos de série abaixo (temporário).');
                } else {
                    $.toast && $.toast({
                        text: 'Erro: ' + erro.descriptionError,
                        icon:'error',
                        position:'top-right',
                        hideAfter:6000,
                        loader:false
                    });
                }
            } else {
                $.toast && $.toast({
                    text: 'Erro ao criar séries. Código HTTP: ' + (ft.http_code || 'desconhecido'),
                    icon:'error',
                    position:'top-right',
                    hideAfter:5000,
                    loader:false
                });
            }
            
            console.error('Resultados detalhados:', resp.resultados);
            
            seriesLoading = false;
            toggleSeriesBtn(false);
            $btn.html(oldHtml);
        } else {
            var msg = (resp && resp.message) ? resp.message : 'Erro ao criar séries na AGT';
            $.toast && $.toast({text: msg, icon:'warning', position:'top-right', hideAfter:4000, loader:false});
            
            seriesLoading = false;
            toggleSeriesBtn(false);
            $btn.html(oldHtml);
        }
    })
    .fail(function(xhr, status, error){
        console.error('Erro AJAX:', status, error);
        $.toast && $.toast({text:'Erro de rede ao criar séries: ' + error, icon:'error', position:'top-right', hideAfter:4000, loader:false});
        seriesLoading = false;
        toggleSeriesBtn(false);
        $btn.html(oldHtml);
    })
    .always(function(){
        // Garantir que o botão sempre volta ao normal após timeout
        setTimeout(function(){
            if (seriesLoading) {
                seriesLoading = false;
                toggleSeriesBtn(false);
                $btn.html(oldHtml);
            }
        }, 15000); // 15 segundos timeout
    });
}

function listarSeriesAgt(){
    var jaExiste = seriesJaExistemNaDB();
    
    seriesLoading = true;
    toggleSeriesBtn(true);

    var $btn = $('#btnConsultarSeries');
    var oldHtml = $btn.html();
    $btn.html('<i class="fa fa-spinner fa-spin"></i> A consultar...');

    $.getJSON(ENDPOINT_SERIES, {
        send: 1,
        establishmentNumber: getEstablishmentNumber()
    })
    .done(function(resp){
        if (resp && resp.ok && resp.http_code == 200){
            // SEMPRE preencher os campos primeiro
            fillSeriesFromAgt(resp);

            if (jaExiste){
                // Já existe na DB → só consultar / mostrar (não gravar novamente)
                $.toast && $.toast({
                    text:'Séries consultadas e preenchidas nos campos!',
                    icon:'success',
                    position:'top-right',
                    hideAfter:3200,
                    loader:false
                });
                seriesLoading = false;
                toggleSeriesBtn(false);
                $btn.html(oldHtml);
                return;
            }

            // Não existe na DB → guardar UMA VEZ automaticamente
            $.toast && $.toast({
                text:'Séries carregadas. A guardar pela 1ª vez...',
                icon:'success',
                position:'top-right',
                hideAfter:2500,
                loader:false
            });

            setTimeout(function(){
                $('form.validation').trigger('submit');
            }, 400);

        } else {
            var msg = (resp && resp.error) ? resp.error : 'Não foi possível consultar as séries.';
            $.toast && $.toast({text: msg, icon:'warning', position:'top-right', hideAfter:3500, loader:false});
        }
    })
    .fail(function(){
        $.toast && $.toast({text:'Erro de rede ao consultar séries.', icon:'error', position:'top-right', hideAfter:3500, loader:false});
    })
    .always(function(){
        seriesLoading = false;
        toggleSeriesBtn(false);
        $btn.html(oldHtml);
    });
}

$(document).on('click', '#btnConsultarSeries', function(){
    consultarSeriesAgt();
});

// Variáveis para armazenar valores originais das séries da BD
var seriesFromDB = {
    'FT-seriesCode': $('#FT-seriesCode').val(),
    'FR-seriesCode': $('#FR-seriesCode').val(),
    'GF-seriesCode': $('#GF-seriesCode').val(),
    'NC-seriesCode': $('#NC-seriesCode').val(),
    'RC-seriesCode': $('#RC-seriesCode').val()
};

console.log('Séries carregadas da BD:', seriesFromDB);

// Função para verificar se as séries começam com o prefixo correto e gerenciar readonly
function toggleSeriesReadonly() {
    var ftSeriesCode = $('#FT-seriesCode').val();
    var startsWithFT = ftSeriesCode && ftSeriesCode.toString().toUpperCase().startsWith('FT');
    
    console.log('FT-seriesCode:', ftSeriesCode, '- Começa com FT:', startsWithFT);
    
    if (startsWithFT) {
        // Séries começam com FT - tornar readonly
        $('#FT-seriesCode').prop('readonly', true);
        $('#FR-seriesCode').prop('readonly', true);
        $('#GF-seriesCode').prop('readonly', true);
        $('#NC-seriesCode').prop('readonly', true);
        $('#RC-seriesCode').prop('readonly', true);
        $('#private').prop('readonly', true);
        $('#public').prop('readonly', true);
        console.log('Campos marcados como readonly (séries válidas)');
    } else {
        // Séries não começam com FT - deixar editáveis
        $('#FT-seriesCode').prop('readonly', false);
        $('#FR-seriesCode').prop('readonly', false);
        $('#GF-seriesCode').prop('readonly', false);
        $('#NC-seriesCode').prop('readonly', false);
        $('#RC-seriesCode').prop('readonly', false);
        $('#private').prop('readonly', false);
        $('#public').prop('readonly', false);
        console.log('Campos marcados como editáveis (séries não válidas)');
    }
}

// Gerenciar visibilidade dos campos conforme o tipo de faturação
function toggleFieldsByTipoFaturacao() {
    var tipoFaturacao = $('#tipo_faturacao').val();
    
    if (tipoFaturacao === 'SAF-T AO') {
        // Ocultar campos
        $('#grupo-private').hide();
        $('#grupo-public').hide();
        $('#grupo-diagnostico').hide();
        $('#grupo-software-validation').hide();
        $('#grupo-series-agt').hide();
        
        // Preencher séries com SIF2026
        $('#FT-seriesCode').val('SIF2026');
        $('#FR-seriesCode').val('SIF2026');
        $('#GF-seriesCode').val('SIF2026');
        $('#NC-seriesCode').val('SIF2026');
        $('#RC-seriesCode').val('SIF2026');
        
        // Remover required dos campos ocultos
        $('#private').prop('required', false);
        $('#public').prop('required', false);
        $('#SoftwareValidationNumber').prop('required', false);
    } else {
        // Mostrar campos
        $('#grupo-private').show();
        $('#grupo-public').show();
        $('#grupo-diagnostico').show();
        $('#grupo-software-validation').show();
        $('#grupo-series-agt').show();
        
        // Restaurar séries com valores originais da BD
        $('#FT-seriesCode').val(seriesFromDB['FT-seriesCode']);
        $('#FR-seriesCode').val(seriesFromDB['FR-seriesCode']);
        $('#GF-seriesCode').val(seriesFromDB['GF-seriesCode']);
        $('#NC-seriesCode').val(seriesFromDB['NC-seriesCode']);
        $('#RC-seriesCode').val(seriesFromDB['RC-seriesCode']);
        
        // Adicionar required aos campos visíveis
        $('#private').prop('required', true);
        $('#public').prop('required', true);
        $('#SoftwareValidationNumber').prop('required', true);
        
        // Verificar se séries são válidas para aplicar readonly
        toggleSeriesReadonly();
    }
}

// Executar ao carregar a página
$(document).ready(function() {
    // Primeiro verificar se as séries são válidas (começam com FT)
    toggleSeriesReadonly();
    
    // Depois aplicar visibilidade conforme tipo de faturação
    toggleFieldsByTipoFaturacao();
});

// Executar ao mudar a seleção
$('#tipo_faturacao').on('change', function() {
    toggleFieldsByTipoFaturacao();
});
</script>
