<style>
/* ===============================
   FORÇAR COLUNAS SEM QUEBRA
   =============================== */

/* Nº/Facturas */
#SLData th:nth-child(3),
#SLData td:nth-child(3){
    white-space: nowrap !important;
    min-width: 160px !important;
    font-weight: 600;
}

/* Relacionado */
#SLData th:nth-child(4),
#SLData td:nth-child(4){
    white-space: nowrap !important;
    min-width: 170px !important;
    font-size: 12px;
}

/* AÇÕES */
#SLData th.col-actions,
#SLData td.col-actions{
    white-space: nowrap !important;
    width: 150px !important;
    min-width: 150px !important;
    max-width: 150px !important;
    text-align: center;
}

/* Botões SEM quebra */
#SLData td.col-actions .btn-group{
    display: inline-flex !important;
    flex-wrap: nowrap !important;
    white-space: nowrap !important;
}

/* Botões compactos estilo ERP */
#SLData td.col-actions .btn{
    padding: 4px 6px !important;
    margin: 0 1px !important;
    font-size: 12px !important;
    line-height: 1 !important;
}

/* Ícones alinhados */
#SLData td.col-actions .btn i{
    margin: 0 !important;
}

/* ===============================
   AJUSTES GERAIS DE TABELA
   =============================== */
#SLData td,
#SLData th{
    vertical-align: middle !important;
}

/* Impede quebra em qualquer badge */
#SLData .label{
    white-space: nowrap !important;
}

/* Botão bulk ao lado do length */
#SLData_length #btnSendAllAgt{
    margin-left:10px;
}
#SLData_length #agtBulkInfo{
    margin-left:8px;
    font-size:12px;
    display:inline-block;
}

/* Linhas anuladas a vermelho */
#SLData tr.row-anulado {
    background-color: #ffcccc !important;
}
#SLData tr.row-anulado td {
    background-color: #ffcccc !important;
    color: #8b0000;
    font-weight: 500;
}
</style>

<script>
$(document).ready(function () {

    function dateOnly(d){
        if(!d) return '';
        var s = (d + '').split(' ')[0]; // YYYY-MM-DD
        var p = s.split('-');
        if(p.length === 3) return p[2] + '-' + p[1] + '-' + p[0]; // DD-MM-YYYY
        return s;
    }

    function _upper(v){
        return (v === null || v === undefined) ? "" : (""+v).toUpperCase().trim();
    }

    function sleep(ms){
        return new Promise(resolve => setTimeout(resolve, ms));
    }

    async function consultarDepoisDeEnviar(invoiceId){
        // consulta estado 2s após o envio
        await sleep(2000);
        try {
            await $.ajax({
                url: base_url + "agt/obter_estado/" + invoiceId,
                type: "GET",
                data: { send: 1 },
                dataType: "json",
                timeout: 60000
            });
        } catch (e) {
            // mantemos silencioso para não travar a fila
        }
    }

    /**
     * REGRAS:
     * 1) mesa = NC  OU InvoiceNo começa com "NC" → só IMPRIMIR
     * 2) agt_status = VALIDA                    → remove Enviar + Obter AGT
     */
    function filtraActions(actionsHtml, row){
        if(!actionsHtml) return '';

        var mesa      = _upper(row.mesa);
        var agt       = _upper(row.agt_status);
        var invoiceNo = _upper(row.InvoiceNo || "");

        var $wrap = $("<div>").html(actionsHtml);

        // 1) NC: mesa=NC OU InvoiceNo começa por NC -> só imprimir
        if(mesa === "NC" || invoiceNo.indexOf("NC") === 0){
            var $first = $wrap.find(".btn-group a").first();
            if($first.length){
                $wrap.find(".btn-group").html($first.clone());
                return $wrap.html();
            }
            // fallback
            var $firstAny = $wrap.find("a").first();
            $wrap.html($firstAny.length ? $firstAny.clone() : "");
            return $wrap.html();
        }

        // 2) AGT VALIDA: remove ambos os botões AGT
        if(agt === "VALIDA"){
            $wrap.find("a").filter(function(){
                var href = (($(this).attr("href") || "")).toLowerCase();
                return (
                    href.indexOf("/agt/registar_factura/") >= 0 ||
                    href.indexOf("/agt/obter_estado/") >= 0
                );
            }).remove();
            return $wrap.html();
        }

        // 3) AGT ENVIADO: remove só o botão Enviar, mantém Consultar
        if(agt === "ENVIADO"){
            $wrap.find("a").filter(function(){
                var href = (($(this).attr("href") || "")).toLowerCase();
                return href.indexOf("/agt/registar_factura/") >= 0;
            }).remove();
            return $wrap.html();
        }

        // 4) Para CONSULTADO, ERRO ou outros: mantém ambos os botões
        // (não precisa fazer nada, retorna como está)

        return actionsHtml;
    }

    // ---------------- DataTable ----------------
    $('#SLData').dataTable({
        "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, '<?= lang('all'); ?>']],
        "aaSorting": [[0, "desc"]],
        "iDisplayLength": <?= (int)$Settings->rows_per_page ?>,
        "bProcessing": true,
        "bServerSide": true,
        "sAjaxSource": "<?= site_url('sales/get_invoices') ?>",

        "fnServerData": function (sSource, aoData, fnCallback) {
            aoData.push({
                "name": "<?= $this->security->get_csrf_token_name() ?>",
                "value": "<?= $this->security->get_csrf_hash() ?>"
            });
            $.ajax({
                dataType: 'json',
                type: "POST",
                url: sSource,
                data: aoData,
                success: fnCallback
            });
        },

        "aoColumns": [
            { // 0 - Data (só data)
                "mData": "date",
                "mRender": function(data){ return dateOnly(data); }
            },

            { "mData": "customer_name" }, // 1 - Cliente
            { "mData": "InvoiceNo" },      // 2 - Nº/Facturas
            { "mData": "OriginatingON" },  // 3 - Relacionado
            { "mData": "grand_total", "mRender": currencyFormat }, // 4 - Total
            { "mData": "paid",        "mRender": currencyFormat }, // 5 - Pago
            { "mData": "balance",     "mRender": currencyFormat }, // 6 - Valor a Pagar

            { // 7 - Status (mostra Anulado se mesa=NC)
                "mData": "mesa",
                "className": "col-status",
                "mRender": function (data) {
                    return (data === "NC")
                        ? "<span class='label label-danger'>Anulado</span>"
                        : "<span class='label label-info'>Normal</span>";
                }
            },

            { // 8 - AGT
                "mData": "agt_status",
                "className": "text-center"
            },

            { // 9 - Ações (com regras)
                "mData": "Actions",
                "className": "col-actions",
                "bSortable": false,
                "bSearchable": false,
                "mRender": function (data, type, row) {
                    data = data ? data : '';
                    return filtraActions(data, row);
                }
            }
        ],

        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull){
            // Destaca linhas NC (anuladas) a vermelho
            if(aData.mesa === "NC" || aData.InvoiceType === "NC"){
                $(nRow).addClass("row-anulado");
            }
            return nRow;
        },

        // ✅ quando a tabela estiver pronta: injecta botão + lógica
        "fnInitComplete": function () {

            // ------- inject botão ao lado do "Show entries" -------
            if(!$("#btnSendAllAgt").length){
                var btnHtml =
                    '<button id="btnSendAllAgt" type="button" class="btn btn-primary btn-sm">' +
                        '<i class="fa fa-send"></i> Enviar Pendentes p/ AGT' +
                    '</button>' +
                    '<span id="agtBulkInfo"></span>';

                $("#SLData_length").append(btnHtml);
            }

            // ------- bulk send em fila -------
            var running = false;

            function info(msg){
                $("#agtBulkInfo").html(msg || "");
            }

            async function enviarFila(ids){
                if(!ids || !ids.length){
                    info("<span class='text-muted'>Nada pendente.</span>");
                    return;
                }

                running = true;
                $("#btnSendAllAgt").prop("disabled", true);

                var ok = 0, erro = 0;

                for (var i = 0; i < ids.length; i++) {
                    var id = ids[i];

                    info("A enviar <b>" + (i+1) + "</b>/" + ids.length + " | OK: " + ok + " | ERRO: " + erro);

                    try{
                        await $.ajax({
                            url: base_url + "agt/registar_factura/" + id,
                            type: "GET",
                            data: { send: 1 },
                            dataType: "json",
                            timeout: 60000
                        });
                        ok++;
                        await consultarDepoisDeEnviar(id);
                    }catch(e){
                        erro++;
                    }

                    await sleep(400);
                }

                info("<span class='text-success'><b>Concluído</b></span> | OK: " + ok + " | ERRO: " + erro);

                running = false;
                $("#btnSendAllAgt").prop("disabled", false);

                // refresca lista sem perder página
                $('#SLData').dataTable().fnDraw(false);
            }

            // click do botão (delegado para evitar perder após redraw)
            $("body").off("click", "#btnSendAllAgt").on("click", "#btnSendAllAgt", function(){
                if(running) return;

                if(!confirm("Queres enviar para a AGT todas as facturas pendentes (AGT != VALIDA)?")){
                    return;
                }

                info("<span class='text-muted'>A carregar pendentes...</span>");

                $.ajax({
                    url: base_url + "sales/get_pending_agt_ids",
                    type: "GET",
                    dataType: "json",
                    timeout: 60000,
                    success: function(res){
                        if(!res || !res.ok){
                            info("<span class='text-danger'>Erro ao buscar pendentes.</span>");
                            return;
                        }
                        enviarFila(res.ids || []);
                    },
                    error: function(){
                        info("<span class='text-danger'>Erro de rede ao buscar pendentes.</span>");
                    }
                });
            });

        }
    });

    // Envio individual via AJAX: envia e consulta estado 2s depois
    $("body").off("click", ".btn-agt-send").on("click", ".btn-agt-send", async function(e){
        e.preventDefault();

        var $btn = $(this);
        if($btn.data("busy")) return;
        $btn.data("busy", true);

        var invoiceId = extractSaleId($btn.attr("href"));
        if(!invoiceId){
            $btn.data("busy", false);
            return window.location.href = $btn.attr("href");
        }

        try{
            await $.ajax({
                url: base_url + "agt/registar_factura/" + invoiceId,
                type: "GET",
                data: { send: 1 },
                dataType: "json",
                timeout: 60000
            });
            await consultarDepoisDeEnviar(invoiceId);
        }catch(err){
            // se falhar envio continuamos a refrescar
        }

        $btn.data("busy", false);
        $('#SLData').dataTable().fnDraw(false);
    });

});
</script>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('list_results'); ?></h3>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table id="SLData" class="table table-striped table-bordered table-condensed table-hover">
                            <thead>
                                <tr class="active">
                                    <th class="col-sm-1"><?php echo $this->lang->line("date"); ?></th>
                                    <th class="col-xs-4"><?php echo $this->lang->line("customer"); ?></th>
                                    <th class="col-sm-1"><?php echo $this->lang->line("Nº/Facturas"); ?></th>
                                    <th class="col-sm-1"><?php echo $this->lang->line("Relacionado"); ?></th>
                                    <th class="col-sm-1"><?= lang("grand_total"); ?></th>
                                    <th class="col-sm-1"><?= lang("paid"); ?></th>
                                    <th class="col-sm-1"><?= lang("due_amount"); ?></th>
                                    <th class="text-center col-status"><?php echo $this->lang->line("status"); ?></th>
                                    <th class="text-center col-agt">AGT</th>
                                    <th class="col-actions"><?php echo $this->lang->line("actions"); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td colspan="10" class="dataTables_empty"><?= lang('loading_data_from_server'); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="modal" data-easein="flipYIn" id="ncModal" tabindex="-1" role="dialog" aria-labelledby="tsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md modal-success">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="tsModalLabel"><?= lang('Motivo da Anulação'); ?></h4>
            </div>
            <div class="modal-body">
                <input type='text' class='form-control input-sm kb-pad' id='nc_reason' onClick='this.select();' value='' placeholder="Atenção, está acção não permitirá recuperar está Factura" style="height: 40px;">
                <input type="hidden" id="invoice_id">
                Esta informação será enviada a AGT
            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-sm pull-left" data-dismiss="modal"><?= lang('close') ?></button>
                <button type="button" id="convertNc" class="btn btn-primary btn-sm"><?= lang('save') ?></button>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
$(function(){

    $("body").on("click",".convert-nc-btn", function(){
        $("#nc_reason").val("");
        $("#invoice_id").val($(this).data("id"));
        $('#ncModal').modal({backdrop: 'static'});
    });

    $("body").on("click","#convertNc", function(){
        $.ajax({
            type: "get",
            url: base_url + 'sales/convert_Nc_invoice',
            data: {id:$("#invoice_id").val(), reason: $("#nc_reason").val()},
            dataType: "json",
            success: function (res) {
                $('#ncModal').modal("hide");
                window.open(base_url + 'pos/printInvoice/'  + res.sale_id, '_blank');
            }
        });
    });

    $("body").on("mouseover",".add_payment_btn",function(){
        var tt = $(this).closest("tr").find("td").eq(7).text();
        if(tt == "Canceled" || tt == "Cancelada"){
            $(this).removeAttr("data-toggle");
        }
    });

    $("body").on("click",".add_payment_btn",function(e){
        var tt = $(this).closest("tr").find("td").eq(7).text();
        if(tt == "Canceled" || tt == "Cancelada"){
            alert("Voce não pode Adicinar Pagamentos em Facturas Anuladas");
            e.preventDefault();
        }
    });

<?php if($this->session->userdata("add_payment") == "yes"){ ?>
    window.open("printPaymentInvoice/<?= $this->session->userdata("sale_id")?>","PrintPaymentInvoice");
<?php
    $this->session->unset_userdata("add_payment");
    $this->session->unset_userdata("sale_id");
} ?>

<?php if($this->session->userdata("cancel_payment") == "yes"){ ?>
    window.open("printPaymentInvoice/<?= $this->session->userdata("sale_id")?>","PrintPaymentInvoice");
<?php
    $this->session->unset_userdata("cancel_payment");
    $this->session->unset_userdata("sale_id");
} ?>

<?php if(!empty($this->session->userdata("reprint"))){ ?>
    setTimeout(function(){
        $(".print<?php echo $this->session->userdata("reprint"); ?>").click();
    }, 500);
<?php $this->session->unset_userdata("reprint"); } ?>

});
</script>
