<?php
$v = "?code=".$code;
?>
<script>
	$(document).ready(function () {
		$('#SLData').dataTable({
			"aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, '<?= lang('all'); ?>']],
            "aaSorting": [[ 0, "desc" ]], "iDisplayLength": <?= $Settings->rows_per_page ?>,
			'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?= site_url('reports/get_invoices_by_product/'. $v) ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?= $this->security->get_csrf_token_name() ?>",
                    "value": "<?= $this->security->get_csrf_hash() ?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
            "aoColumns": [{"mRender":hrld}, null, null,null,{"mRender":currencyFormat},{"mRender":currencyFormat},{"mRender":currencyFormat},{"mRender": function(data){
            	if(data == "NC") 
            		return "<?php echo lang("Anulado"); ?>";
            	else 
            		return "<?php echo lang("normal"); ?>";

            }}, {"bSortable":false, "bSearchable": false}]
		});
		

	});

</script>

<section class="content">
	<div class="row">
		<div class="col-xs-12">
			<div class="box box-primary">
				<div class="box-header">
					<h3 class="box-title"><?= lang('list_results'); ?></h3>
				</div>
				<div class="box-body">
					<div class="table-responsive">
						<table id="SLData" class="table table-striped table-bordered table-condensed table-hover">
							<thead>
								<tr class="active">
									<th class="col-sm-2" ><?php echo $this->lang->line("date"); ?></th>
									<th class="col-xs-2" ><?php echo $this->lang->line("customer"); ?></th>
									<th class="col-xs-1"><?php echo $this->lang->line("Nº/Facturas"); ?></th>
                                    <!-- <th class="col-xs-2"><?php echo $this->lang->line("paid"); ?></th> -->
									<th class="col-xs-1"><?php echo $this->lang->line("Relacionado"); ?></th>
									<th class="col-sm-1"><?= lang("grand_total"); ?></th>
                                    <th class="col-sm-1"><?= lang("paid"); ?></th>
                                    <th class="col-sm-1"><?= lang("due_amount"); ?></th>
                                    <th class="col-xs-1 text-center" ><?php echo $this->lang->line("status"); ?></th>
									<th class="col-sm-2"><?php echo $this->lang->line("actions"); ?></th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td colspan="10" class="dataTables_empty"><?= lang('loading_data_from_server'); ?></td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="clearfix"></div>
				</div>
			</div>
		</div>
	</div>
</section>

<div class="modal" data-easein="flipYIn" id="ncModal" tabindex="-1" role="dialog" aria-labelledby="tsModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md modal-success">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                <h4 class="modal-title" id="tsModalLabel"><?= lang('Motivo da Anulação'); ?></h4>
            </div>
            <div class="modal-body">
                <input type='text' class='form-control input-sm kb-pad' id='nc_reason' onClick='this.select();' value='' placeholder="Atenção, está acção não permitirá recuperar está Factura" style="height: 40px;">
                <input type="hidden" name="" id="invoice_id">
              	Esta informação será enviada a AGT
            </div>
			
            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-sm pull-left" data-dismiss="modal"><?= lang('close') ?></button>
                <button type="button" id="convertNc" class="btn btn-primary btn-sm"><?= lang('save') ?></button>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
	$(function(){
		$("body").on("click",".convert-nc-btn", function(){
			$("#nc_reason").val("");
			$("#invoice_id").val($(this).data("id"));
		 	$('#ncModal').modal({backdrop: 'static'});
		})
		$("body").on("click","#convertNc", function(){
			 $.ajax({
                type: "get",
                url: base_url + 'sales/convert_Nc_invoice',
                data: {id:$("#invoice_id").val(), reason: $("#nc_reason").val()},
                dataType: "json",
                success: function (res) {
		 			$('#ncModal').modal("hide");
		 			window.open(base_url + 'pos/printInvoice/'  + res.sale_id ,target='_blank'); 
                }
            });

		})

		$("body").on("click",".edit_invoice_btn",function(e){
			if($(this).closest("tr").find("td").eq(5).text() != "0.00" && $(this).closest("tr").find("td").eq(5).text() != "0,00"){
				alert("Não é Permitido Editar Facturas Pagas ou com Nota de Crédito emitida");
				e.preventDefault();
			}
		})

		$("body").on("click",".delete_invoice",function(e){
			if($(this).closest("tr").find("td").eq(5).text() != "0.00" && $(this).closest("tr").find("td").eq(5).text() != "0,00"){
				alert("Não é Permitido Eliminar Facturas Pagas");
				e.preventDefault();
			} else {
				return confirm($(this).data("title"));
			}
		})


		$("body").on("mouseover",".add_payment_btn",function(e){
			
			var tt = $(this).closest("tr").find("td").eq(7).text();
			if(tt == "Canceled" || tt == "Cancelada"){
				$(this).removeAttr("data-toggle");
			}
		})


		$("body").on("click",".add_payment_btn",function(e){
			var tt = $(this).closest("tr").find("td").eq(7).text();
			if(tt == "Canceled" || tt == "Cancelada"){
				alert("Voce não pode Adicinar Pagamentos em Facturas Anuladas");
				e.preventDefault();
			}
		})



		
			<?php
		if($this->session->userdata("add_payment") == "yes"){
?>
		window.open("printPaymentInvoice/<?= $this->session->userdata("sale_id")?>","PrintPaymentInvoice");
<?php			
			$this->session->unset_userdata("add_payment");
	        $this->session->unset_userdata("sale_id");
		}
	?>
<?php

		if($this->session->userdata("cancel_payment") == "yes"){
?>

		window.open("printPaymentInvoice/<?= $this->session->userdata("sale_id")?>","PrintPaymentInvoice");
		// window.open("<?= site_url('pos/printInvoice') ?>/<?= $this->session->userdata("sale_id")?>","PrintPaymentInvoice");
<?php			
			$this->session->unset_userdata("cancel_payment");
	        $this->session->unset_userdata("sale_id");
		}
	?>

	<?php
		if(!empty($this->session->userdata("reprint"))){

	?>	
			setTimeout(function(){
				$(".print<?php echo $this->session->userdata("reprint"); ?>").click();
			}, 500) ;
	
	<?php
		$this->session->unset_userdata("reprint");
		}
	?>
	})
</script>