<?php
(defined('BASEPATH')) OR exit('No direct script access allowed');
?>
<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title">Please fill in the information below.</h3>
                </div>
                <div class="box-body">
                    <div class="col-lg-12">
                            <?= form_open_multipart("printer/add", 'class="validation"'); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                <?= lang('Title', 'title'); ?>
                                    <?= form_input('title', set_value('title'), 'class="form-control tip" id="title"  required="required"'); ?>
                                </div>
                                <div class="form-group">
                                <?= lang('type', 'type'); ?>
                                    <?php $opts = array('network' => 'Network', 'windows' => 'Windows', 'linux' => 'Linux'); ?>
                                    <?= form_dropdown('type', $opts, set_value('type', 'network'), 'class="form-control tip select2" id="type" onchange="changeType()"  required="required" style="width:100%;"'); ?>
                                </div>
                                <div class="form-group">
                                <?= lang('profile', 'profile'); ?>
                                    <?php $opts = array('default' => 'Default', 'simple' => 'Simple', 'star-branded' => 'Star-branded', 'espon tep' => 'Espon Tep', 'p822d' => 'P822D'); ?>
                                    <?= form_dropdown('profile', $opts, set_value('profile', 'default'), 'class="form-control tip select2" id="profile"  required="required" style="width:100%;"'); ?>
                                </div>

                                <div class="form-group">
                                     <?= lang('Characters Per Line', 'Characters Per Line'); ?>
                                    <?= form_input('chars_per_line', set_value('chars_per_line'), 'class="form-control tip" id="chars_per_line"  required="required"'); ?>
                                </div>
                                <div class="form-group" id="ip_section">
                            <?= lang('IP Address', 'IP Address'); ?> 
                                    <?= form_input('ip_address', set_value('ip_address'), 'class="form-control tip" id="ip_address"'); ?>
                                </div>
                              

                                <div class="form-group" id="port_section">
<?= lang('Port', 'port'); ?>
                                    <?= form_input('port', set_value('port'), 'class="form-control tip" id="port"'); ?>
                                </div>
                                  <div class="form-group" id="path_section">
<?= lang('Path', 'path'); ?>
                                    <?= form_input('path', set_value('path'), 'class="form-control tip" id="path"'); ?>
                                <?= "<b>For Windows</b>: (Local USB, Serial or Parallel Printer): Share the printer and enter the share name for your printer here or for Server Message Block (SMB): enter as a smb:// url format such as smb://computername/Receipt Printer <br />
<b>For Linux</b>: Parallel as /dev/lp0, USB as /dev/usb/lp1, USB-Serial as /dev/ttyUSB0, Serial as /dev/ttyS0" ?>
                                  </div>
                              
                               
                            </div>
                        </div>                      
                        <div class="form-group">
<?= form_submit('add_printer', lang('Add Printer'), 'class="btn btn-primary"'); ?>
                        </div>
                            <?= form_close(); ?>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    $(document).ready(function() {
    //console.log( "ready!" );
    $('#path_section').hide();
});
//changeType()
function changeType() {
    //alert('getting here');
    if (document.getElementById("type").value == "network"){
        //alert('network selected');
       // document.getElementById("message").innerHTML = "Common message";
       $('#ip_section').show();
        $('#port_section').show();
        $('#path_section').hide();
    } else if(document.getElementById("type").value == "windows"){
        //document.getElementById("message").innerHTML = "Having a Baby!!";
        //alert('windows selected');
        $('#ip_section').hide();
        $('#port_section').hide();
        $('#path_section').show();
    }else if(document.getElementById("type").value == "linux"){
       // alert('linux selected');
       $('#ip_section').hide();
        $('#port_section').hide();
         $('#path_section').show();
    }        
}

</script>