<?php
/**
 * cash_sale.php — POS (layout atualizado)
 * Mantém IDs usados no seu JS/PHP:
 *  #nif, #customer, #cidade, #morada, #add_item, #posTable
 * Ligue as chamadas MinFin/totais onde há TODO.
 */
?>
<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="utf-8">
  <title>POS • Caixa</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- CDN (remova se já tem local) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.4.1/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

  <style>
    :root{ --night:#0e0f1a; --night-2:#151726; --night-3:#1d2033; --ink:#e7edf9; --muted:#9aa3b2; --brand:#10b981; }
    html,body{ height:100%; } body{ background:var(--night); color:var(--ink); }

    /* Topbar */
    .pos-topbar{ background:var(--night-2); border-bottom:1px solid rgba(255,255,255,.06);
      padding:10px 15px; display:flex; align-items:center; justify-content:space-between; }
    .pos-topbar .title{ display:flex; align-items:center; gap:12px; }
    .pos-topbar .title img{ height:22px; }
    .pos-topbar .links .btn{ margin-left:6px; }

    /* Inputs/labels */
    .form-label, label{ color:var(--muted); font-weight:500; }
    .form-control, .input-group-addon, .input-group .btn, select.form-control{
      background:var(--night-3); color:var(--ink); border:1px solid rgba(255,255,255,.08);
    }
    .form-control:focus{ outline:0; box-shadow:none; border-color:#2e3a55; }
    .input-group-lg .form-control{ height:3rem; font-size:1.05rem; }

    /* Pesquisa produto */
    .pos-search{ border:1px solid rgba(255,255,255,.08); border-radius:.5rem; overflow:hidden;
      box-shadow:0 0 0 1px rgba(255,255,255,.03) inset; }
    .pos-search .input-group-addon{ background:transparent; border:0; }
    .pos-search input{ border:0; background:transparent; }

    /* Tabela */
    .pos-table{ max-height:44vh; overflow:auto; border:1px solid rgba(255,255,255,.06); border-radius:.5rem; }
    .table{ margin-bottom:0; }
    .table>thead>tr>th{ background:var(--night-2); color:var(--ink); border-color:rgba(255,255,255,.05); }
    .pos-table thead{ position:sticky; top:0; z-index:3; }
    .pos-table tbody tr{ height:56px; }
    .table>tbody>tr>td, .table>thead>tr>th{ border-color:rgba(255,255,255,.06); }

    /* Totais fixos */
    .pos-totals{ position:sticky; bottom:0; z-index:4;
      background:linear-gradient(180deg, rgba(14,15,26,.88) 0, rgba(14,15,26,.95) 100%);
      border:1px solid rgba(255,255,255,.06); border-left:0; border-right:0;
      display:flex; align-items:center; justify-content:space-between; gap:1rem;
      padding:.75rem 1rem; border-radius:.5rem; margin-top:12px; }
    .pos-totals .mini{ display:flex; gap:20px; font-size:.95rem; color:var(--muted); }
    .pos-totals .mini strong{ color:var(--ink); }
    .pos-totals .total-badge{ font-size:1.8rem; font-weight:800; letter-spacing:.5px;
      background:var(--night-3); padding:.25rem .75rem; border-radius:.5rem; }

    /* Botões */
    .btn{ border-radius:.6rem; }
    .btn-success{ background:var(--brand); border-color:var(--brand); color:#052b20; font-weight:700; }
    .btn-outline{ background:transparent; color:var(--ink); border:1px solid rgba(255,255,255,.18); }
    .btn-outline:hover{ background:rgba(255,255,255,.08); }

    .mt-6{ margin-top:18px; }
    .toastish{ position:fixed; right:1rem; bottom:1rem; background:#1f2937; color:#fff;
      padding:.75rem 1rem; border-radius:.5rem; display:none; }

    @media (max-width:768px){
      .pos-table{ max-height:40vh; }
      .pos-totals .total-badge{ font-size:1.4rem; }
      .pos-topbar .links .btn{ display:none; }
    }
  </style>
</head>
<body>

  <!-- Topbar -->
  <div class="pos-topbar">
    <div class="title">
      <img src="/assets/img/logo.svg" alt="Logo">
      <strong>POS • Caixa</strong>
      <span class="text-muted" style="font-size:12px">/ <?= isset($operator_name)? htmlspecialchars($operator_name) : 'Operador' ?></span>
    </div>
    <div class="links">
      <span class="hidden-xs text-muted" style="margin-right:10px">F1 Ajuda • F2 Cliente • F3 Produto • F4 Pagamento</span>
      <a href="/reports/monthly" class="btn btn-outline btn-xs">Vendas Mensais</a>
      <a href="/reports/daily" class="btn btn-outline btn-xs">Vendas Diárias</a>
      <a href="/cash/close" class="btn btn-outline btn-xs">Fechar Caixa</a>
    </div>
  </div>

  <div class="container-fluid" style="padding:15px">

    <!-- Documento / NIF / Cliente -->
    <div class="row">
      <div class="col-xs-12 col-md-3">
        <label class="form-label">Documento</label>
        <!-- TODO: substitua pelo seu select real -->
        <?php
          echo isset($document_select_html)
            ? $document_select_html
            : '<select id="document" class="form-control"><option>FACTURA</option><option>RECIBO</option><option>PROFORMA</option></select>';
        ?>
      </div>

      <div class="col-xs-12 col-md-3">
        <label class="form-label">NIF <span class="text-muted" style="font-size:12px">(Enter para buscar)</span></label>
        <div class="input-group">
          <input id="nif" class="form-control" placeholder="0000000000" autofocus>
          <span class="input-group-addon" id="nif-loading" style="display:none"><i class="fa fa-refresh fa-spin"></i></span>
        </div>
        <div id="nif-toast" class="text-warning" style="font-size:12px;display:none">NIF não encontrado no MinFin.</div>
      </div>

      <div class="col-xs-12 col-md-6">
        <label class="form-label">Cliente</label>
        <div class="input-group">
          <!-- TODO: se usa select2, coloque aqui o select/hidden id -->
          <input id="customer" class="form-control" placeholder="Cliente final">
          <span class="input-group-btn">
            <button type="button" class="btn btn-outline" id="add-customer" title="Adicionar Cliente">
              <i class="fa fa-plus"></i>
            </button>
          </span>
        </div>
      </div>
    </div>

    <!-- Município / Morada -->
    <div class="row mt-6">
      <div class="col-xs-12 col-md-4">
        <label class="form-label">Município</label>
        <input id="cidade" class="form-control" placeholder="Benguela">
      </div>
      <div class="col-xs-12 col-md-8">
        <label class="form-label">Morada</label>
        <input id="morada" class="form-control" placeholder="Benguela, Benguela">
      </div>
    </div>

    <!-- Pesquisa de produtos -->
    <div class="row mt-6">
      <div class="col-xs-12">
        <label class="form-label">Produto</label>
        <div class="input-group input-group-lg pos-search">
          <span class="input-group-addon"><i class="fa fa-barcode"></i></span>
          <input id="add_item" class="form-control" placeholder="Procure por código, nome ou código de barras (F3)">
        </div>
      </div>
    </div>

    <!-- Tabela -->
    <div class="row mt-6">
      <div class="col-xs-12">
        <div class="pos-table">
          <table id="posTable" class="table table-hover">
            <thead>
              <tr>
                <th style="width:10%">Código</th>
                <th>Produto</th>
                <th style="width:10%">Preço</th>
                <th style="width:8%">Taxa</th>
                <th style="width:8%">Qtd</th>
                <th style="width:10%">Desc.</th>
                <th style="width:12%">Subtotal</th>
                <th style="width:6%"></th>
              </tr>
            </thead>
            <tbody id="items-body">
              <!-- TODO: render dinâmico das linhas -->
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <!-- Totais -->
    <div class="row">
      <div class="col-xs-12">
        <div class="pos-totals">
          <div class="mini">
            <span>Total de Itens: <strong id="t_itens">0 (0,00)</strong></span>
            <span>Desc.: <strong id="t_desc">0,00</strong></span>
            <span>Taxa: <strong id="t_taxa">0,00</strong></span>
            <span>Total: <strong id="t_bruto">0,00</strong></span>
          </div>
          <div>
            <span class="text-muted" style="margin-right:8px">Total a Pagar</span>
            <span class="total-badge" id="t_pagar">0,00</span>
          </div>
        </div>
      </div>
    </div>

    <!-- Ações -->
    <div class="row" style="margin-top:12px; margin-bottom:10px">
      <div class="col-xs-12 col-sm-6 col-md-3">
        <button class="btn btn-outline btn-block btn-lg" id="btn-await">
          <i class="fa fa-hourglass-half"></i> Aguardar
        </button>
      </div>
      <div class="col-xs-12 col-sm-6 col-md-3">
        <button class="btn btn-outline btn-block btn-lg" id="btn-cancel">
          <i class="fa fa-times-circle"></i> Cancelar
        </button>
      </div>
      <div class="col-xs-12 col-sm-6 col-md-3">
        <button class="btn btn-outline btn-block btn-lg" id="btn-discount">
          <i class="fa fa-gift"></i> Desc.
        </button>
      </div>
      <div class="col-xs-12 col-sm-6 col-md-3">
        <button class="btn btn-success btn-block btn-lg" id="payment">
          <i class="fa fa-credit-card"></i> Pagamento (F4)
        </button>
      </div>
    </div>

  </div><!-- /container -->

  <div class="toastish" id="toastish"></div>

  <!-- JS -->
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.4.1/dist/js/bootstrap.min.js"></script>

  <script>
  (function(){
    function toast(msg, ms){ var t=$('#toastish'); t.text(msg).fadeIn(150); setTimeout(()=>t.fadeOut(200), ms||2500); }

    // Foco / atalhos
    $('#nif').focus().on('keydown', function(e){ if(e.key==='Enter') $('#nif').trigger('buscar-minfin'); });
    $(document).on('keydown', function(e){
      if(e.key==='F2'){ e.preventDefault(); $('#customer').focus().select(); }
      if(e.key==='F3'){ e.preventDefault(); $('#add_item').focus().select(); }
      if(e.key==='F4'){ e.preventDefault(); $('#payment').trigger('click'); }
    });

    // Lookup NIF (ligue ao seu endpoint)
    $('#nif').on('buscar-minfin', function(){
      $('#nif-loading').show(); $('#add-customer').prop('disabled', true);

      // ===== TODO: substitua este setTimeout pelo seu $.ajax(...) =====
      setTimeout(function(){
        var nif = ($('#nif').val()||'').trim();
        var ok = !!nif && nif.length>=9; // condição fictícia
        $('#nif-loading').hide(); $('#add-customer').prop('disabled', false);

        if(!ok){
          $('#nif-toast').show(); toast('NIF não encontrado no MinFin.', 2600);
          setTimeout(function(){ $('#nif-toast').fadeOut(200); }, 2400);
        }else{
          // Ex.: preencher dados retornados
          // $('#customer').val(res.nome); $('#cidade').val(res.municipio); $('#morada').val(res.morada);
        }
      }, 700);
      // ===============================================================
    });

    // Atualização de totais (exponha esta função no seu fluxo)
    window.atualizarTotais = function(itens, desc, taxa, total, pagar){
      $('#t_itens').text(itens); $('#t_desc').text(desc);
      $('#t_taxa').text(taxa); $('#t_bruto').text(total); $('#t_pagar').text(pagar);
    };

    // Clique pagamento
    $('#payment').on('click', function(){
      // TODO: chamar modal/rota de pagamento
      toast('Abrir Pagamento…');
    });
  })();
  </script>
</body>
</html>
