<?php

function product_name($name) {
    return character_limiter($name, (isset($Settings->char_per_line) ? ($Settings->char_per_line - 8) : 35));
}
?>
<!doctype html>
<html>
    <head>
        <meta charset="utf-8">
        <title>Factura</title>
        <base href="<?= base_url() ?>"/>
        <meta http-equiv="cache-control" content="max-age=0"/>
        <meta http-equiv="cache-control" content="no-cache"/>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
        <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
        <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= $assets ?>plugins/font-awesome/css/font-awesome.css" rel="stylesheet" type="text/css" />
        <style type="text/css" media="all">
            body { color: #000; }
            #wrapper { max-width: 850px; margin: 0 auto; padding-top: 20px; }
            .btn { border-radius: 0; margin-bottom: 5px; }
            .table { border-radius: 3px; }
            .table th { background: #f5f5f5; }
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }
            .print_color{
                color: black!important;
            }
            .print-color-red{
                color: red!important;
            }
            .td-color{
                background: #B8B3B3 !important;
                color: black!important;
                background-color: #B8B3B3 !important;
                color: black!important;
                width: 100%;
                padding: 0px;
                margin: 0px;
                font-size: 14px;
                padding: 5px 10px;
            }
            .tr-footer td{
                font-weight: bold;
            }
            .print-spec{
                min-height: 150px;
            }
            .no-screen{
                display: none;
            }
            .cancelado {
                display: block;
                position: absolute;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                z-index: -1;
                opacity : 0.1;
            }
            @media print {
                .no-screen{
                    display: table;
                }
                .no-print { display: none; }
                .text-align-right{
                    text-align: right !important;
                    width: 100% !important;
                }
                #wrapper { max-width: 780px; width: 100%; min-width: 250px; margin: 0 auto;
                }
                .print_color{
                    color: #000000 !important;
                }
                .print-color-red{
                    color: #ff8100 !important;
                }
                .td-color{
                    background-color: #B8B3B3 !important;
                    color: black!important;
                    width: 100%;
                    padding: 0px;
                    margin: 0px;
                    font-size: 18px;
                    padding: 5px 0px;
                    padding-left: 5px !important;
                }
                .td-color font{
                    background-color: #B8B3B3 !important;
                    color: black!important;
                    width: 100%;
                    padding: 0px;
                    margin: 0px;
                    font-size: 18px;
                    padding: 5px 0px;
                    padding-left: 5px !important;
                }
                .cancelado {
                    display: block;
                    position: absolute;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    z-index: -1;
                    opacity : 0.1;

                }
            }
            p{
                margin: 0px;
            }
            .total_table th{
                height: 25px;
                vertical-align: top;
                font-size: 12px;
            }
        </style>
    </head>
    <body>
        <div id="wrapper"  >
            <div id="receiptData" width="350px" height="" border="0"  cellpadding="12" cellspacing="5" class="resultado">
                <div class="no-print">                  
                </div>
                <div class="cancelado">
                    <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>"  width="500" height="250" border="0" />
                </div>
                <div  id="receipt-data" >
                    <div class="text-center" style="font-size: 12px;" >
                        <table style="width: 100%">
                            <tr>
                                <td width="50%" style="text-align: left;">
                                    <table style="width: 100%;">
                                        <tr>
                                            <td width="50%" style="text-align: left; padding-right: 20px;">
                                                <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logotipo"  width="<?= $Settings->cancel_sale; ?>" height="<?= $Settings->suspend_sale; ?>" border="0" />
                                            </td>
                                        </tr>
                                        <tr>
                                            <td width="50%" style="padding-left: 5px;">
                                                <p style="font-size: 14px; font-weight: bold;"><p style="font-size: 14px; font-weight: bold;">
                                                    <!--   <?= $Settings->CompanyName; ?> -->
                                                </p>
                                            </td>
                                        </tr>
                                    </table>
                                    <table>
                                        <tr>
                                            <td>
                                                <img src="<?php echo $assets . "/images/icon_print.png"; ?>">
                                            </td>
                                            <td  valign="bottom">
                                                <p style="  padding: 1px 2px;">
                                                    <?php
                                                    $n3 = substr($Settings->CompanyName, 0, 3);
                                                    $expired_month = base64_decode($Settings->expired_month);
                                                    $licenca = $Settings->licence;
                                                    $licence_data = $Settings->CompanyName . "^" . $Settings->TaxRegistrationNumber . "^" . base64_decode($Settings->expired_month);

                                                    $licence = hash("md5", $licence_data);

                                                    if ($licenca == $licence)
                                                        echo $Settings->CompanyName;
                                                    else
                                                        echo "DEMOSTRAÇÃO";
                                                    ?>
                                                </p>
                                                <p style="padding: 1px 2px;">
                                                    <?php
                                                    if ($licenca == $licence)
                                                        echo $Settings->AddressDetail;
                                                    else
                                                        echo "DEMOSTRAÇÃO";
                                                    ?>
                                                </p>
                                                <p style=" padding: 1px 2px;">
                                                    <?php
                                                    if ($licenca == $licence && strtotime(date('Y-m-d')) <= strtotime($expired_month))
                                                        echo $Settings->TaxRegistrationNumber;
                                                    else
                                                        echo "DEMOSTRAÇÃO";
                                                    ?>   
                                                </p>
                                                <p style=" padding: 1px 2px;">
                                                    <?= $Settings->phone; ?>
                                                </p>
                                                <p style="padding: 1px 2px;">
                                                    <?= $Settings->Email; ?>
                                                </p>
                                                <p style="padding: 1px 2px;">
                                                    <?= $Settings->Website; ?>
                                                </p>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <!-- <td width="50%" style="text-align: left; padding-left: 10%; vertical-align: top; padding-top: 5px;">
                                    
                                    <p >
                                        <?php
                                        echo '<b style="font-size: 12px ">' . lang("reference") . ':</b>';
                                        echo $depot->reference;
                                        ?>
                                    </p>
                                    <p>
                                        <?php
                                        echo '<b style="font-size: 12px ">Status: </b> ';
                                        if ($depot->received == 0) {
                                            echo "EMCOMENDAS";
                                        } else {
                                            echo "ENTRADA ARMAZEM";
                                        }
                                        ?>

                                    </p>

                                </td> -->
                            </tr>
                        </table>
                        <table style="width: 100%; margin: 25px 0px;">
                            <tr>
                                <td class="text-center" style="width:60%">
                                    <h3>FOLHA DE CALCULOS</h3>
                                </td>
                                <td  style="width:40%;border: 1px solid black; padding:5px">
                                    <table  style="width: 100%; ">
                                        <tr>
                                            <th style="width: 50%;">DATA</th>
                                            <td class="text-left" style="width: 50%;"><?= $this->tec->hrld($depot->date); ?></td>
                                        </tr>
                                        <tr>
                                            <th style="width: 50%;">FOLHA Nr.:</th>
                                            <td class="text-left" style="width: 50%;"><?= $depot->id ?></td>
                                        </tr>
                                        <tr>
                                            <th style="width: 50%;">MOEDA</th>
                                            <td class="text-left" style="width: 50%;">Kz</td>
                                        </tr>
                                        <tr>
                                            <th style="width: 50%;">FOB</th>
                                            <td class="text-left" style="width: 50%;" id="fob_text"></td>
                                        </tr>
                                        <tr>
                                            <th style="width: 50%;">DESPESAS ADICIONAIS</th>
                                            <td class="text-left" style="width: 50%;"></td>
                                        </tr>
                                        <tr>
                                            <th style="width: 50%;">COEFICENTE (%)</th>
                                            <td class="text-left" style="width: 50%;"></td>
                                        </tr>
                                        <tr>
                                            <th style="width: 50%;">PERCENTAGEM DE VEND</th>
                                            <td class="text-left" style="width: 50%;"></td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                        <table style="width: 100%; margin: 25px 0px;" class="table  table-bordered ">
                            <thead>
                                <tr>
                                    <th rowspan="2" style="background: transparent;">Code</th>
                                    <th rowspan="2" style="background: transparent;">Designaca do Artigo</th>
                                    <th rowspan="2" style="background: transparent;">Aremanzem</th>
                                    <th rowspan="2" style="background: transparent;">Quant.</th>
                                    <th rowspan="2" style="background: transparent;">Q. Emb</th>
                                    <th rowspan="2" style="background: transparent;">Total</th>
                                    <th colspan="2" style="background: transparent;">Preco de Compra</th>
                                    <th colspan="2" style="background: transparent;">Preco Com as Despesas</th>
                                    <th colspan="2" style="background: transparent;">Preco de Vendas</th>
                                    <th rowspan="2" style="background: transparent;">Diferenca</th>
                                </tr>
                                <tr>
                                    <th style="background: transparent;">Preco</th>
                                    <th style="background: transparent;">Valor</th>
                                    <th style="background: transparent;">Preco</th>
                                    <th style="background: transparent;">Valor</th>
                                    <th style="background: transparent;">Preco</th>
                                    <th style="background: transparent;">Valor</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php                                    
                                    $total_compra_valor=0;
                                    $total_vendas_valor=0;
                                    $total_diff=0;
                                ?>
                                <?php foreach($items as $arr){ ?>
                                    <?php 
                                            $compra_valor= $arr->quantity*$arr->cost;
                                            $vendas_valor= $arr->quantity*$arr->product_price;
                                            $diff = $vendas_valor - $compra_valor;
                                            $total_compra_valor +=  $compra_valor;
                                            $total_vendas_valor +=  $vendas_valor;
                                            $total_diff += $diff;

                                    ?>
                                <tr >
                                    <td style="font-size: 9px;"><?php echo $arr->product_code; ?></td>
                                    <td style="font-size: 9px;"><?php echo $arr->product_name; ?></td>
                                    <td style="font-size: 9px;">Principal</td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $arr->quantity; ?></td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $this->tec->formatNumber(1); ?></td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $arr->quantity; ?></td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $this->tec->formatNumber($arr->cost); ?></td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $this->tec->formatNumber($compra_valor); ?></td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $this->tec->formatNumber($arr->cost); ?></td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $this->tec->formatNumber($compra_valor); ?></td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $this->tec->formatNumber($arr->product_price); ?></td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $this->tec->formatNumber($vendas_valor); ?></td>
                                    <td class="text-right" style="font-size: 9px;"><?php echo $this->tec->formatNumber($diff); ?></td>
                                </tr>
                                <?php } ?>
                            </tbody>
                            <thead>
                                <tr>
                                    <th class="text-right" colspan="6" style="background: transparent;">Total</th>
                                    <th class="text-right" colspan="2" style="background: transparent;"><?php echo $this->tec->formatNumber($total_compra_valor); ?></th>
                                    <th class="text-right" colspan="2" style="background: transparent;"><?php echo $this->tec->formatNumber($total_compra_valor); ?></th>
                                    <th class="text-right" colspan="2" style="background: transparent;"><?php echo $this->tec->formatNumber($total_vendas_valor); ?></th>
                                    <th class="text-right" style="background: transparent;"><?php echo $this->tec->formatNumber($total_diff); ?></th>
                                </tr>
                            </thead>
                        </table>
                        <!-- <div class="print-spec">
                            <table width="98%" height="45" class="table table-striped table-condensed" style="margin-top: 5px;">
                                <thead>
                                    <tr>
                                        <th class="print_color text-left" width="5%" ><?= lang('product'); ?></th>
                                        <th class="print_color text-center" width="50%"><?= lang('quantity'); ?></th>
                                        <th class="print_color text-right" width="9%"><?= lang('unit_cost'); ?></th>
                                        <th class="print_color text-right" width="9%"><?= lang('discount'); ?></th>
                                        <th class="print_color text-right" width="9%"><?= lang('order_tax'); ?></th>
                                        <th class="print_color text-right" width="10%"><?= lang('subtotal'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $cost = 0;
                                    $total = 0;
                                    $total_tax = 0;
                                    $total_discount = 0;
                                    foreach ($items as $item) {
                                        $cost += $item->cost;
                                        $discount = (empty($item->item_discount)) ? 0 : $item->item_discount;
                                        $sub_total = $item->quantity * $item->cost + $item->item_tax - $discount;
                                        $total += $sub_total;
                                        $total_tax += $item->item_tax;
                                        $total_discount += $discount;
                                        echo '<tr><td  style="font-size: 10px" width="5%" align="left">' . $item->product_name . ' (' . $item->product_code . ') </td>';
                                        echo '<td  style="font-size: 10px" width="50%"  class="text-center">' . $item->quantity . ' </td>';
                                        echo '<td style="font-size: 10px" width="9%" class="text-right">' . $this->tec->formatNumber($item->cost) . '</td>';
                                        echo '<td  style="font-size: 10px" width="9%"  class="text-center">' . $this->tec->formatNumber($item->item_discount) . ' </td>';
                                        echo '<td style="font-size: 10px" width="9%" class="text-right">' . $this->tec->formatNumber($item->item_tax) . '</td>';
                                        echo '<td style="font-size: 10px" width="10%" class="text-right">';
                                        echo $this->tec->formatMoney($sub_total) . '</td></tr>';
                                    }
                                    ?>
                                    <tr valign="top" style="border-bottom: 1px solid black; background-color: #e4e3e3 !important;">
                                        <td colspan="2" style="text-align: left; font-size: 9px;">
                                            <b>TOTAL</b>
                                        </td>
                                        <td style="text-align: right; font-size: 9px;">
                                            <b> <?= $this->tec->formatNumber($cost); ?></b> 
                                        </td>
                                        <td style="text-align: center; font-size: 9px;">
                                            <b> <?= $this->tec->formatNumber($total_discount); ?></b> 
                                        </td>
                                        <td style="text-align: right; font-size: 9px;">
                                            <b> <?= $this->tec->formatNumber($total_tax); ?></b> 
                                        </td>
                                        <td  style="text-align: right; font-size: 9px;">
                                            <b><?= $this->tec->formatMoney($total); ?></b> 
                                        </td>
                                    </tr>

                                </tbody>

                            </table>
                        </div>
                        <table width="101%" style="width: 100%; margin-top: 10px;">
                            <tr valign="top">
                                <td align="left" style="width: 60%; font-size: 10px;">
                                    <table width="100%">
                                        <tr valign="top" style="border-bottom: 1px solid black; background-color: #e4e3e3 !important;">
                                            <td colspan="5" style="text-align: left; font-size: 9px;">
                                                <?php echo lang("tax_summary"); ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td width="8%" style="text-transform: uppercase; font-size: 9px;">
                                                <?= lang("rate"); ?>
                                            </td>
                                            <td width="15%" style="text-transform: uppercase; font-size: 9px">
                                                <?= lang("incidence"); ?>
                                            </td>
                                            <td width="10%" style="text-transform: uppercase; font-size: 9px">
                                                <?= lang("Monta. do impo."); ?>  
                                            </td>
                                            <td width="8%" align="center" style="text-transform: uppercase; font-size: 9px">
                                                <?= lang("tax_code"); ?>
                                            </td>
                                            <td width="49%" align="right" style="text-transform: uppercase; font-size: 9px">
                                                <?= lang("tax_reason"); ?>
                                            </td>
                                        </tr>
                                        <?php
                                        $this->db->order_by('id', 'asc');
                                        $depot_items = get_rows("tec_purchase_items", array("purchase_id" => $depot->id));
                                        foreach ($depot_items as $item) {
                                            $tax = get_row("tec_tax", array("id" => $item['tax_id']));
                                            echo "<tr>";
                                            echo '<td style="font-size:9px; ">' . $tax['tax'] . '(%)</td>';
                                            echo '<td style="font-size:9px; ">' . $this->tec->formatNumber($item['cost'] * $item['quantity']) . '</td>';
                                            echo '<td width="10%"  style="font-size:9px; ">' . $this->tec->formatNumber($item['item_tax']) . '</td>';
                                            echo '<td width="20%" align="center" style="font-size:9px; ">' . $tax['tax_code'] . ' (' . $item['quantity'] . ')</td>';
                                            echo '<td width="49%" align="right" style="font-size:9px; ">' . $tax['reason'] . '</td>';
                                            echo "</tr>";
                                        }
                                        ?>
                                    </table>
                                </td>
                                <td style="width: 35%;  padding-left: 20px; vertical-align: top; ">
                                    <table style="width: 100%; font-size: 11px;" class="total_table">
                                        <tr> 
                                            <th style="font-size: 11px;"><?= lang("Total Sem Desconto"); ?></th>
                                            <th  style="font-size: 11px;" class="text-right"><?= $this->tec->formatMoney($total + $total_discount ); ?></th>
                                        </tr>
                                       
                                        <tr>
                                            <th  style="font-size: 11px" ><?= lang("Total do Imposto"); ?></th>
                                            <th  class="text-right" style="font-size: 11px"><?= $this->tec->formatMoney($total_tax); ?></th>
                                        </tr>
                                        <tr>
                                            <th  style="font-size: 11px" ><?= lang("Cativo"); ?></th>
                                            <th  class="text-right" style="font-size: 11px">0.00</th>
                                        </tr>
                                        <tr>
                                            <th  style="font-size: 11px" ><?= lang("Ret. Fonte"); ?></th>
                                            <th  class="text-right" style="font-size: 11px"><?php
                                                if ($customer->cep == '1' & $product_info['type'] == 'service' & $inv->total >= 20000) {
                                                    echo $this->tec->formatMoney($ret = $inv->total * 6.5 / 100);
                                                } else {
                                                    echo $ret = 0.00;
                                                }
                                                ?></th>
                                        </tr>
                                       
                                            <tr>
                                                <th style="padding: 0px;"><p class="td-color" style="font-size: 14px"><?= lang("Total"); ?></p></th>
                                                <th style="padding: 0px;"><p class="td-color" style="text-align: right; font-size: 14px;"><?= $this->tec->formatMoney($total); ?></p></th>
                                            </tr>
                                         
                                           
                                    </table> <br>
                                  
                                    <span style="text-align: right; font-weight: bold;"> <?php echo '<b style="font-size: 12px ">Operador:</b>'; ?>
                                        <?= $this->session->userdata('username'); ?>
                                    </span></td>
                            </tr>
                        </table> -->
                    </div>
                    <div style="clear:both;"></div>
                </div>
            </div>
        </div>
    </body>
    <style type="text/css">
        .no-screen-tr{
            display: none;
        }
        .no-screen-p{
            display: none;
        }
        @media print{
            .print-spec{
                min-height: <?php
                if ($inv->paid < $round_total)
                    echo "320px";
                else
                    echo "320px";
                ?>  !important;
            }      
            .no-screen-tr{
                display: table-row;
            }
            .no-screen-tr td{
                border:0px !important;
            }
            .no-screen-p{
                display: block;
            }
        }
        .total_table th{
            height: <?php
            if ($inv->paid < $round_total)
                echo "25px";
            else
                echo "25px";
            ?> ;
            vertical-align:middle;
        }
    </style>    
    <script src="<?= $assets ?>plugins/jQuery/jQuery-2.1.4.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        $("#fob_text").text("<?php echo $this->tec->formatNumber($total_compra_valor); ?>");
        $(document).ready(function () {
            window.print();
        });

    </script>
</html>