<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <title><?= lang('Conta Corrente') . " | " . $Settings->site_name; ?></title>
        <base href="<?= base_url() ?>"/> 
        <meta http-equiv="cache-control" content="max-age=0"/>
        <meta http-equiv="cache-control" content="no-cache"/>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
        <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
        <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="<?= $assets ?>plugins/font-awesome/css/font-awesome.css" rel="stylesheet" type="text/css" />
      
        <style type="text/css" media="all">
            body { color: #000; }
            #wrapper { max-width:95%; margin: 0 auto; padding-top: 15px; }
            .btn { border-radius: 0; margin-bottom: 1px; }
            .table {
                    border-radius: 3px;
                    border: 1px solid #ddd;
                    font-size: 12px;
                }
         
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 2px 0; }
            .cancelado {
                    display: block;
                    position: absolute;
                    border:#9ABBFD;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    z-index: -1;
                    opacity : 0.1;
                    
                }
            @media print {
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }
            .cancelado {
                    display: block;
                    position: absolute;
                    border:#9ABBFD;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    z-index: -1;
                    opacity : 0.1;
                    
                }
				 body { color: #000; }
            #wrapper { max-width:95%; margin: 0 auto; padding-top: 15px; }
            .btn { border-radius: 0; margin-bottom: 2px; }
            .table {
                    border-radius: 3px;
                    border: 1px solid #ddd;
                    font-size: 10px;
                }
         
            }
        </style>
        
    </head>
    <body >
        <div id="wrapper" >
            <div class="cancelado">
            <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logotipo"  width="90%" class="img-responsive" border="0" />
            </div>
            <div  style="alt" id="receipt-data">
                <div class="text-left">
                    <div id="">
                    <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logo" width="150"  class="img-responsive" border="0">  
                        <br>
                        <?= $Settings->CompanyName; ?>
                        <br>
                        <?= $Settings->TaxRegistrationNumber; ?>
                        <br>
                        <?= $Settings->AddressDetail; ?>
                        <br>
                        <?= $Settings->phone; ?>
                        
                        <br>      
                    </div>
                </div>
                <!-- <td width="50%" style="text-align: left; padding-left: 50%; vertical-align: top; padding-top: 5px;">
                     
                        <p style="font-weight: bold; padding-top: 12px; margin-top:20px;"> 
                            <?= lang("dear_sir") ?> 
                        </p>
                        <p>
                            <?php    echo $customer_name;?>
                        </p>
                       
                        <p>
                             <?php  echo '<b style="font-size: 12px ">NIF: </b> ';
							 if($customer->cf1 == "999999999") echo "Consumidor Final "; else echo $customer->cf1;?>
                      </p>
                        <p>
                            <?php  echo '<b style="font-size: 12px ">Morada: </b> ';echo $customer->endereco; ?>
                            
                        </p>
                <p>
                            <?php  echo $customer->estado; ?>
                            
                      </p>
                    </td> -->
                <div class="row" style="margin-top:10px;">
                    <div class="col-md-12 text-center text-primary">
                        <h4>Extracto de conta Cliente : <?php echo $customer->name ?></h4> 
                    </div>
                    <div class="col-md-12">
                        <table class="table"  width="100%">
                            <thead>
                                <td bgcolor="#9ABBFD" class="text-right"><strong>Data</strong></td>
                                <td bgcolor="#9ABBFD" class="text-right"><strong>Documento</strong></td>
                                <td bgcolor="#9ABBFD" class="text-right"><strong>Dif. Arred.</strong></td>
                                <td bgcolor="#9ABBFD" class="text-right"><strong>Dif. Cambio</strong></td>
                                <td bgcolor="#9ABBFD" class="text-right"><strong>Débito</strong></td>
                                <td bgcolor="#9ABBFD" class="text-right"><strong>Crédito</strong></td>
                           
                                <td bgcolor="#9ABBFD" class="text-right"><strong>Saldo</strong></td>
                            </thead>
                            <tbody>
                                <tr>
                                    <th colspan="6" class="text-primary"></th>
                                </tr>
                                <?php 
                                    $total_paid=0;
                                    $total_amount=0;
                                    $total_balance = 0;
                                ?>
                                <?php foreach($alldata as $key=>$arr){ 
                                    $invoices=explode(" ", $arr->InvoiceNo);
                                    if($invoices[0]== "NC"){
                                        $subtotal="";
                                        $pos_paid=$arr->subtotal;
                                    }else{
                                        $subtotal=$arr->subtotal;
                                        $pos_paid=$arr->pos_paid;
                                    }

                                    $total_paid= $total_paid+$pos_paid;
                                    $total_amount= $total_amount+$subtotal;    
                                    $total_balance =   $total_balance +  $subtotal -  $pos_paid;                           
                                    ?>                                    
                                    <tr>
                                        <td class="text-right" style="width:4%"><?php echo date_format(date_create($arr->date), "d-m-Y") ?></td>
                                        <td class="text-right" style="width:6%"><?php echo $arr->InvoiceNo ?></td>
                                        <td class="text-right" style="width:5%"><?php echo $arr->total_tax ?></td>
                                        <td class="text-right" style="width:5%"><?php echo $arr->total_discount ?></td>
                                        <td class="text-right" style="width:4%"><?php echo number_format($subtotal,2) ;  ?></td>
                                        <td class="text-right" style="width:4%"><?php echo number_format($pos_paid,2) ?></td>
                                        
                                        <td class="text-right" style="width:4%"><?php echo number_format($total_balance,2); ?></td>
                                    </tr>
                                <?php }?>
                                <tr>
                                    <th class="text-center" colspan="4">Saldo Final</th>
                                   
                                    <th class="text-right"><?php echo number_format($total_amount, 2, ".", "."); ?></th>
                                    <th class="text-right"><?php echo number_format($total_paid, 2, ".", "."); ?></th>
                                    <th class="text-right"><?php echo number_format($total_balance, 2, ".", "."); ?></th>
                                </tr>
                            </tbody>                            
                        </table>
                    </div>
                    <div class="col-md-12" style="margin-top:20px;">
                        <table class="table table-bordered" style="width: 30%; float: right; font-size: 12px;">
                            <tr>
                                <th width="50%" bgcolor="#9ABBFD"><strong>Total 
                                <?= lang("paid"); ?>:</strong></th>
                                <td width="50%" class="text-right"><strong><?php echo number_format($total_paid,2) ; ?></strong></td>
                            </tr>                            
                            <tr>
                                <th bgcolor="#FF9596"><strong>Total à Pagar:</strong></th>
                                <td class="text-right"><strong><?php echo number_format($total_balance,2) ; ?></strong></td>
                            </tr>                           
                        </table>
                    </div> 
                </div>                
            </div>
        </div>
    </body>
    <script src="<?php echo base_url(); ?>themes/default/assets/plugins/jQuery/jQuery-2.1.4.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        // $(function(){
        //     window.print();
        // })
    </script>
</html>