<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <title><?= lang('Conta Corrente') . " | " . $Settings->site_name; ?></title>
        <base href="<?= base_url() ?>"/> 
        <meta http-equiv="cache-control" content="max-age=0"/>
        <meta http-equiv="cache-control" content="no-cache"/>
        <meta http-equiv="expires" content="0"/>
        <meta http-equiv="pragma" content="no-cache"/>
        <link rel="shortcut icon" href="<?= $assets ?>images/icon.png"/>
        <link href="<?= $assets ?>bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
      
        <style type="text/css" media="all">
            body { color: #000; }
            #wrapper { max-width:95%; margin: 0 auto; padding-top: 20px; }
            .btn { border-radius: 0; margin-bottom: 2px; }
            .table {
    border-radius: 3px;
    border: 1px solid #ddd;
    font-size: 10px;
}
         
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }
            .cancelado {
                    display: block;
                    position: absolute;
                    border:#9ABBFD;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    z-index: -1;
                    opacity : 0.1;
                    
                }
            @media print {
            .table th, .table td { vertical-align: middle !important; }
            h3 { margin: 5px 0; }
            .cancelado {
                    display: block;
                    position: absolute;
                    border:#9ABBFD;
                    top: 50%;
                    left: 50%;
                    transform: translate(-50%, -50%);
                    z-index: -1;
                    opacity : 0.1;
                    
                }
				 body { color: #000; }
            #wrapper { max-width:95%; margin: 0 auto; padding-top: 20px; }
            .btn { border-radius: 0; margin-bottom: 2px; }
            .table {
    border-radius: 3px;
    border: 1px solid #ddd;
    font-size: 10px;
}
         
            }
        </style>
        
    </head>
    <body >
        <div id="wrapper" >             
            <div class="cancelado">
                <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logotipo"  width="90%" class="img-responsive" border="0" />
            </div>
            
            <div  style="al" id="receipt-data">
                <div class="text-left">
                    <div id="">
                        <img src="<?php echo $assets; ?>images/header/<?= $Settings->logo; ?>" alt="Logo" width="150"  class="img-responsive" border="0">  
                        <br>
                        <?= $Settings->CompanyName; ?>
                        <br>
                        <?= $Settings->TaxRegistrationNumber; ?>
                        <br>
                        <?= $Settings->AddressDetail; ?>
                        <br>
                        <?= $Settings->phone; ?>
                        
                        <br>      
                    </div>
                </div>
               
                <div class="row" style="margin-top:10px;">
                    <div class="col-md-12 text-center">
                        <h4>Conta Corrente</h4>
                    </div>
                    <div class="col-md-12">
                        <table class="table table-bordered"  width="90%">
                            <thead>
                                <tr>
                                    <th bgcolor="#9ABBFD" class="text-center" ><strong><?php echo $this->lang->line("date"); ?></strong></th>
                                    <th bgcolor="#9ABBFD"  class="text-center" ><strong><?php echo $this->lang->line("customer"); ?></strong></th>
									<th bgcolor="#9ABBFD" class="text-center"><strong><?php echo $this->lang->line("InvoiceNo"); ?></strong></th>
									<th bgcolor="#9ABBFD" class="text-center"><strong><?php echo $this->lang->line("status"); ?></strong></th>
									<th bgcolor="#9ABBFD" class="text-center"><strong>
								    <?= lang("total"); ?>
									</strong></th>
                                    <th bgcolor="#9ABBFD" class="text-center"><strong>
                                    <?= lang("paid"); ?>
                                    </strong></th>
                                    <th bgcolor="#9ABBFD" class="text-center"><strong>
                                    <?= lang("due_amount"); ?>
                                    </strong></th>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                    $total_paid=0;
                                    $total_amount=0;
                                ?>
                                <?php foreach($alldata as $key=>$arr){ 
                                    $total_paid= $total_paid+$arr->paid;
                                    $total_amount= $total_amount+$arr->balance;
                                    if($arr->status == "partial"){
                                        $status=lang("Pago Parcial");
                                    }elseif($arr->status == "paid"){
                                        $status=lang("Pago");
                                    }else{
                                        $status=lang("Não Pago");
                                    }
                                   
                                    if($arr->InvoiceStatus == "A") 
                                        $InvoiceStatus=lang("canceled");
                                    else 
                                        $InvoiceStatus=lang("normal");
                                    ?>                                    
                                    <tr>
                                        <td class="text-center" style="width:8%"><?php echo $arr->date ?></td>
                                        <td class="text-right" style="width:15%"><?php echo $arr->customer_name ?></td>
                                        <td class="text-right" style="width:7%"><?php echo $arr->InvoiceNo ?></td>
                                        <td class="text-center" style="width:5%"><?php echo $status; ?></td>
                                        <td class="text-right" style="width:5%"><?php echo number_format($arr->grand_total,2) ;  ?></td>
                                        <td class="text-right" style="width:5%"><?php echo number_format($arr->paid,2) ?></td>
                                        <td class="text-right" style="width:5%"><?php echo number_format($arr->balance,2);  $total_balance += $arr->balance;  ?></td>
                                        
                                    </tr>
                                <?php }?>
                            </tbody>
                        </table>
                    </div>
                    
                </div>
                <div class="row" style="margin-top:20px;">
                    <div class="col-md-12">
                        <table class="table table-bordered" style="width: 30%; float: right; font-size: 12px;">
                            <tr>
                                <th width="50%" bgcolor="#9ABBFD"><strong>Total 
                                <?= lang("paid"); ?>:</strong></th>
                                <td width="50%" class="text-right"><strong><?php echo number_format($total_paid,2) ; ?></strong></td>
                            </tr>
                            <tr>
                                <th bgcolor="#FF9596"><strong>Total à Pagar:</strong></th>
                                <td class="text-right"><strong><?php echo number_format($total_balance,2) ; ?></strong></td>
                            </tr>                           
                        </table>
                    </div>                    
                </div>
            </div>
        </div>
    </body>
    <script src="<?php echo base_url(); ?>themes/default/assets/plugins/jQuery/jQuery-2.1.4.min.js" type="text/javascript"></script>
    <script type="text/javascript">
        // $(function(){
        //     window.print();
        // })
    </script>
</html>