<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<script type="text/javascript">
    $(document).ready(function() {
        $('#UTable').dataTable();
    });
</script>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header">
                    <h3 class="box-title"><?= lang('list_results'); ?></h3>
                    <button type="button" onclick="onadd_modal()" class="btn btn-primary pull-right" style="margin-right:  15px;"><i class="fa fa-plus"></i>&nbsp;Adicionar</button>
                </div>
                <div class="box-body">
                    <table id="UTable" class="table table-bordered table-striped table-hover">
                        <thead class="cf">
                        <tr>
                            <th><?php echo lang('first_name'); ?></th>
                            <th><?php echo lang('last_name'); ?></th>
                            <th><?php echo lang('email'); ?></th>
                            <th><?php echo lang('group'); ?></th>
                            <th style="width:100px;"><?php echo lang('status'); ?></th>
                            <th style="width:80px;"><?php echo lang('actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        foreach ($users as $user) {
                            if($user->group =="super_admin" && !$this->Super_admin) continue;
                            echo '<tr>';
                            echo '<td>' . $user->first_name . '</td>';
                            echo '<td>' . $user->last_name . '</td>';
                            echo '<td>' . $user->email . '</td>';
                            echo '<td>' . $user->group . '</td>';
                            echo '<td class="text-center" style="padding:6px;">' . ($user->active ? '<span class="label label-success">' . lang('active') . '</span' : '<span class="label label-danger">' . lang('inactive') . '</span>') . '</td>';
                            echo '<td class="text-center" style="padding:6px;"><div class="btn-group btn-group-justified" role="group"><div class="btn-group btn-group-xs" role="group"><a class="tip btn btn-warning btn-xs" title="' . lang("profile") . '" href="' . site_url('users/profile/' . $user->id) . '"><i class="fa fa-edit"></i></a></div>
                            <div class="btn-group btn-group-xs" role="group"><a class="tip btn btn-danger btn-xs" title="' . lang("delete_user") . '" href="' . site_url('auth/delete/' . $user->id) . '" onclick="return confirm(\''.lang('alert_x_user').'\')"><i class="fa fa-trash-o"></i></a></div></div></td>';
                            echo '</tr>';
                        }
                        ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
<div class="modal fade" id="AddUserModal" tabindex="-1" role="dialog" aria-labelledby="picModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-1x">&times;</i>
                </button>
                <h4 class="modal-title" id="myModalLabel"><?= lang('add_user'); ?></h4>
            </div>
            <div class="modal-body">
            <?php echo form_open_multipart("auth/create_user", 'class="validation"'); ?>
                <div class="form-group">
                    <?= lang("group", "group"); ?>
                    <?php
                    $gp[""] = "";
                    foreach ($groups as $group) {
                        if($group['id'] == 4 && !$this->Super_admin) continue;
                        $gp[base64_encode($group['id'])] = $group['description'];
                    }
                    echo form_dropdown('group', $gp, set_value('group'), 'id="group" data-placeholder="' . lang("select") . ' ' . lang("group") . '" class="form-control input-tip select2" style="width:100%;"');
                    ?>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('first_name', 'first_name'); ?>
                            <?= form_input('first_name', set_value('first_name'), 'class="form-control tip" id="first_name"  required="required"'); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('last_name', 'last_name'); ?>
                            <?= form_input('last_name', set_value('last_name'), 'class="form-control tip" id="last_name"  required="required"'); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('phone', 'phone'); ?>
                            <?= form_input('phone', set_value('phone'), 'class="form-control tip" id="phone"  required="required"'); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('gender', 'gender'); ?>
                            <?php $gnders = array('male' => lang('male'), 'female' => lang('female')); ?>
                            <?= form_dropdown('gender', $gnders, set_value('gender'), 'class="form-control tip select2" style="width:100%;" id="gender"  required="required"'); ?>
                        </div> 
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('email', 'email'); ?>
                            <?= form_input('email', set_value('email'), 'class="form-control tip" id="email"  required="required"'); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('username', 'username'); ?>
                            <?= form_input('username', set_value('username'), 'class="form-control tip" id="username"  required="required"'); ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('password', 'password'); ?>
                            <?= form_password('password', '', 'class="form-control tip" id="password"  required="required"'); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <?= lang('confirm_password', 'confirm_password'); ?>
                            <?= form_password('confirm_password', '', 'class="form-control tip" id="confirm_password"  required="required"'); ?>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <?= lang('status', 'status'); ?>
                    <?php
                    $opt = array('' => '', 1 => lang('active'), 0 => lang('inactive'));
                    echo form_dropdown('status', $opt, (isset($_POST['status']) ? $_POST['status'] : ''), 'id="status" data-placeholder="' . lang("select") . ' ' . lang("status") . '" class="form-control input-tip select2" style="width:100%;"');
                    ?>
                </div>
                <div class="form-group">
                    <label class="checkbox" for="notify"><input type="checkbox" name="notify" value="1" id="notify" checked="checked"/> <?= lang('notify_user_by_email') ?></label>
                </div>
                <div class="text-right">
                    <button type="button" data-dismiss="modal" aria-hidden="true" class="btn btn-danger"><?= lang('close'); ?></button>
                    <button type="submit" class="btn btn-primary"><?= lang('add_user'); ?></button>
                </div>
                <?php echo form_close();?>
            </div>
        </div>
    </div>
</div>
<script>
    function onadd_modal(){
        $("#AddUserModal").modal();
    }
</script>
