<!DOCTYPE html>
<html>
<head>
    <title><?= $page_title ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/css/bootstrap.min.css">
    <style>
        body { padding: 20px; background: #f4f4f4; }
        .container { max-width: 1200px; }
        .stat-box { 
            padding: 15px; 
            margin-bottom: 20px; 
            border-radius: 5px; 
            color: white; 
            text-align: center;
            font-size: 18px;
            font-weight: bold;
        }
        .stat-pending { background: #ff9800; }
        .stat-processing { background: #2196F3; }
        .stat-done { background: #4CAF50; }
        .stat-failed { background: #f44336; }
        .queue-table { background: white; border-radius: 5px; }
        .status-badge {
            padding: 5px 10px;
            border-radius: 3px;
            color: white;
            font-size: 11px;
            font-weight: bold;
        }
        .status-pending { background: #ff9800; }
        .status-processing { background: #2196F3; }
        .status-done { background: #4CAF50; }
        .status-failed { background: #f44336; }
        .btn-sm { padding: 3px 8px; font-size: 11px; }
        .error-text { 
            font-size: 11px; 
            color: #666;
            max-height: 50px;
            overflow: auto;
            background: #f9f9f9;
            padding: 5px;
            border-radius: 3px;
        }
        h1 { margin-top: 0; }
    </style>
</head>
<body>
    <div class="container">
        <h1>AGT Queue Monitor</h1>

        <!-- Alerts -->
        <?php if ($this->session->flashdata('message')): ?>
            <div class="alert alert-success alert-dismissable">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <?= $this->session->flashdata('message') ?>
            </div>
        <?php endif; ?>
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger alert-dismissable">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <?= $this->session->flashdata('error') ?>
            </div>
        <?php endif; ?>

        <!-- Statistics -->
        <div class="row">
            <div class="col-md-3">
                <div class="stat-box stat-pending">
                    <div><?= $stats['pending'] ?></div>
                    <small>Pending</small>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-box stat-processing">
                    <div><?= $stats['processing'] ?></div>
                    <small>Processing</small>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-box stat-done">
                    <div><?= $stats['done'] ?></div>
                    <small>Done</small>
                </div>
            </div>
            <div class="col-md-3">
                <div class="stat-box stat-failed">
                    <div><?= $stats['failed'] ?></div>
                    <small>Failed</small>
                </div>
            </div>
        </div>

        <!-- Queue List -->
        <div class="queue-table">
            <table class="table table-striped table-hover">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Sale ID</th>
                        <th>Invoice</th>
                        <th>Type</th>
                        <th>Total</th>
                        <th>Status</th>
                        <th>Attempts</th>
                        <th>Next Attempt</th>
                        <th>Created</th>
                        <th>Error</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($rows)): ?>
                        <?php foreach ($rows as $r): ?>
                            <tr>
                                <td><?= $r->id ?></td>
                                <td><?= $r->sale_id ?></td>
                                <td>
                                    <?php if ($r->sale): ?>
                                        <strong><?= $r->sale->InvoiceNo ?></strong>
                                    <?php else: ?>
                                        <em>(not found)</em>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($r->sale): ?>
                                        <span class="label label-info"><?= $r->sale->InvoiceType ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($r->sale): ?>
                                        <strong><?= number_format($r->sale->grand_total, 2, ',', '.') ?></strong>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="status-badge status-<?= $r->status ?>">
                                        <?= strtoupper($r->status) ?>
                                    </span>
                                </td>
                                <td><?= $r->attempts ?>/10</td>
                                <td>
                                    <small>
                                        <?php if ($r->next_attempt): ?>
                                            <?= date('Y-m-d H:i', strtotime($r->next_attempt)) ?>
                                        <?php else: ?>
                                            <em>-</em>
                                        <?php endif; ?>
                                    </small>
                                </td>
                                <td>
                                    <small><?= date('Y-m-d H:i', strtotime($r->created_at)) ?></small>
                                </td>
                                <td>
                                    <?php if ($r->last_error): ?>
                                        <div class="error-text" title="<?= htmlspecialchars($r->last_error) ?>">
                                            <?= substr($r->last_error, 0, 50) ?>...
                                        </div>
                                    <?php else: ?>
                                        <em>-</em>
                                    <?php endif; ?>
                                </td>
                                <td style="white-space: nowrap;">
                                    <?php if ($r->status === 'failed' || $r->status === 'pending'): ?>
                                        <a href="<?= site_url('agt/queue_reprocess/' . $r->id) ?>" 
                                           class="btn btn-xs btn-warning" 
                                           title="Retry">
                                            <i class="glyphicon glyphicon-refresh"></i> Retry
                                        </a>
                                    <?php endif; ?>
                                    <a href="<?= site_url('agt/queue_clear/' . $r->id) ?>" 
                                       class="btn btn-xs btn-danger" 
                                       onclick="return confirm('Remove from queue?')"
                                       title="Remove">
                                        <i class="glyphicon glyphicon-trash"></i> Remove
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="11" class="text-center text-muted">
                                <em>No items in queue</em>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <p style="margin-top: 20px; text-align: center; color: #666;">
            <small>Last updated: <?= date('Y-m-d H:i:s') ?></small>
        </p>
    </div>

    <script src="https://code.jquery.com/jquery-1.12.4.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@3.3.7/dist/js/bootstrap.min.js"></script>
</body>
</html>
