$(document).ready(function() {
    loadItems();
    $("#date").inputmask("yyyy-mm-dd hh:mm", {"placeholder": "yyyy-mm-dd hh:mm"});
    $("#add_item").autocomplete({
        source: base_url+'depot/suggestions',
        minLength: 1,
        autoFocus: false,
        delay: 200,
        response: function (event, ui) {
            if ($(this).val().length >= 16 && ui.content[0].id == 0) {
                bootbox.alert(lang.no_match_found, function () {
                    $('#add_item').focus();
                });
                $(this).val('');
            }
            else if (ui.content.length == 1 && ui.content[0].id != 0) {
                ui.item = ui.content[0];
                $(this).data('ui-autocomplete')._trigger('select', 'autocompleteselect', ui);
                $(this).autocomplete('close');
            }
            else if (ui.content.length == 1 && ui.content[0].id == 0) {
                bootbox.alert(lang.no_match_found, function () {
                    $('#add_item').focus();
                });
                $(this).val('');
            }
        },
        select: function (event, ui) {
            event.preventDefault();
            if (ui.item.id !== 0) {
                var row = add_order_item(ui.item);
                if (row)
                    $(this).val('');
            } else {
                bootbox.alert(lang.no_match_found);
            }
        }
    });

    $('#add_item').bind('keypress', function (e) {
        if (e.keyCode == 13) {
            e.preventDefault();
            $(this).autocomplete("search");
        }
    });

    $('#add_item').focus();
    $('#reset').click(function (e) {
        bootbox.confirm(lang.r_u_sure, function (result) {
            if (result) {
                if (get('spoitems')) {
                    remove('spoitems');
                }

                window.location.reload();
            }
        });
    });       
    $(document).on("change", '.rquantity', function () {
        var row = $(this).closest('tr');
        var new_qty = parseFloat($(this).val()),
        item_id = row.attr('data-item-id');
        spoitems[item_id].row.qty = new_qty;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();
    });

    $(document).on("change", '.rcost', function () {
        var row = $(this).closest('tr');
        var new_cost = parseFloat($(this).val()),
        item_id = row.attr('data-item-id');
        spoitems[item_id].row.cost = new_cost;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();
    });
    $(document).on("change", '.rdiscount', function () {
        var row = $(this).closest('tr');
        var new_discount = parseFloat($(this).val()),
        item_id = row.attr('data-item-id');
        spoitems[item_id].row.discount = new_discount;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();
    });
    $(document).on("change", '.rtax', function () {
        var row = $(this).closest('tr');
        var new_tax = parseFloat($(this).val()),
        item_id = row.attr('data-item-id');            
        spoitems[item_id].row.tax = new_tax;
        store('spoitems', JSON.stringify(spoitems));
        loadItems();
    });
});

function loadItems() {

if (get('spoitems')) {
    total = 0;

    $("#poTable tbody").empty();

    spoitems = JSON.parse(get('spoitems'));

    $.each(spoitems, function () {

        var item = this;
        var item_id = Settings.item_addition == 1 ? item.item_id : item.id;
        spoitems[item_id] = item;

        var product_id = item.row.id, item_cost = item.row.cost, item_qty = item.row.qty, item_tax = item.row.tax, item_code = item.row.code,
        item_name = item.row.name.replace(/"/g, "&#034;").replace(/'/g, "&#039;");
        var item_discount = (item.row.discount) ? item.row.discount : 0;

        var row_no = (new Date).getTime();
      
        var newTr = $('<tr id="' + row_no + '" class="' + item_id + '" data-item-id="' + item_id + '"></tr>');
        tr_html = '<td style="min-width:100px;"><input name="product_id[]" type="hidden" class="rid" value="' + product_id + '"><span class="sname" id="name_' + row_no + '">' + item_name + ' (' + item_code + ')</span></td>';
        tr_html += '<td style="padding:2px;"><select name="tax_id[]" class="form-control select2 tip rtax" id="tax_id" value="' + item_tax + '" data-id="' + row_no + '" data-item="' + item_id + '"  required="required" style="width:100%;" onClick="this.select();">';
                        (item_tax == 1) ? tr_html += '<option selected="selected" value="1">14% | IVA | Regime Geral</option>' : tr_html += '<option value="1">14% | IVA | Regime Geral</option>';
                        (item_tax == 2) ? tr_html += '<option selected="selected" value="2">0% | IVA | Regime Simplificado</option>' : tr_html += '<option value="2">0% | IVA | Regime Simplificado</option>';
                        (item_tax == 3) ? tr_html += '<option selected="selected" value="3">0% | IVA | Transmissão de bens e serviço não sujeita</option>' :  tr_html += '<option value="3">0% | IVA | Transmissão de bens e serviço não sujeita</option>';
                        (item_tax == 4) ? tr_html += '<option selected="selected" value="4">0% | NS | IVA – Regime de Exclusão</option>' : tr_html += '<option value="4">0% | NS | IVA – Regime de Exclusão</option>';                           
                        (item_tax == 5) ? tr_html += '<option selected="selected" value="5">0% | IVA | Isento nos termos da alínea a) do nº1 do artigo 12.º do CIVA</option>' : tr_html += '<option value="5">0% | IVA | Isento nos termos da alínea a) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 7) ? tr_html += '<option selected="selected" value="7">0% | IVA | Isento nos termos da alínea b) do nº1 do artigo 12.º do CIVA</option>' : tr_html += '<option value="7">0% | IVA | Isento nos termos da alínea b) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 8) ? tr_html += '<option selected="selected" value="8">0% | IVA | Isento nos termos da alínea c) do nº1 do artigo 12.º do CIVA</option>' : tr_html += '<option value="8">0% | IVA | Isento nos termos da alínea c) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 9) ? tr_html += '<option selected="selected" value="9">0% | IVA | Isento nos termos da alínea d) do nº1 do artigo 12.º do CIVA</option>' : tr_html += '<option value="9">0% | IVA | Isento nos termos da alínea d) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 10) ? tr_html += '<option selected="selected" value="10">0% | IVA | Isento nos termos da alínea e) do nº1 do artigo 12.º do CIVA</option>' : tr_html += '<option value="10">0% | IVA | Isento nos termos da alínea e) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 11) ? tr_html += '<option selected="selected" value="11">0% | IVA | Isento nos termos da alínea f) do nº1 do artigo 12.º do CIVA</option>' : tr_html += '<option value="11">0% | IVA | Isento nos termos da alínea f) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 12) ? tr_html += '<option selected="selected" value="12">0% | IVA | Isento nos termos da alínea g) do nº1 do artigo 12.º do CIVA</option>': tr_html += '<option value="12">0% | IVA | Isento nos termos da alínea g) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 13) ? tr_html += '<option selected="selected" value="13">0% | IVA | Isento nos termos da alínea h) do nº1 do artigo 12.º do CIVA</option>' : tr_html += '<option value="13">0% | IVA | Isento nos termos da alínea h) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 14) ? tr_html += '<option selected="selected" value="14">0% | IVA | Isento nos termos da alínea i) do nº1 artigo 12.º do CIVA</option>' : tr_html += '<option value="14">0% | IVA | Isento nos termos da alínea i) do nº1 artigo 12.º do CIVA</option>';
                        (item_tax == 15) ? tr_html += '<option selected="selected" value="15">0% | IVA | Isento nos termos da alínea j) do nº1 do artigo 12.º do CIVA</option>' : tr_html += '<option value="15">0% | IVA | Isento nos termos da alínea j) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 16) ? tr_html += '<option selected="selected" value="16">0% | IVA | Isento nos termos da alínea l) do nº1 do artigo 12.º do CIVA</option>' : tr_html += '<option value="16">0% | IVA | Isento nos termos da alínea l) do nº1 do artigo 12.º do CIVA</option>';
                        (item_tax == 17) ? tr_html += '<option selected="selected" value="17">0% | IVA | Isento nos termos da alínea m) do artigo 12.º do CIVA</option>' : tr_html += '<option value="17">0% | IVA | Isento nos termos da alínea m) do artigo 12.º do CIVA</option>';
                        (item_tax == 18) ? tr_html += '<option selected="selected" value="18">0% | IVA | Isento nos termos da alínea n) do artigo 12.º do CIVA</option>' : tr_html += '<option value="18">0% | IVA | Isento nos termos da alínea n) do artigo 12.º do CIVA</option>';
                        (item_tax == 19) ? tr_html += '<option selected="selected" value="19">0% | IVA | Isento nos termos da alínea o) do artigo 12.º do CIVA</option>' : tr_html += '<option value="19">0% | IVA | Isento nos termos da alínea o) do artigo 12.º do CIVA</option>';
                        (item_tax == 20) ? tr_html += '<option selected="selected" value="20">0% | IVA | Isento nos termos da alínea a) do artigo 15.º do CIVA</option>' : tr_html += '<option value="20">0% | IVA  | Isento nos termos da alínea a) do artigo 15.º do CIVA</option>';
                        (item_tax == 21) ? tr_html += '<option selected="selected" value="21">0% | IVA | Isento nos termos da alínea b) do artigo 15.º do CIVA</option>' : tr_html += '<option value="21">0% | IVA  | Isento nos termos da alínea b) do artigo 15.º do CIVA</option>';
                        (item_tax == 22) ? tr_html += '<option selected="selected" value="22">0% | IVA | Isento nos termos da alínea c) do artigo 15.º do CIVA</option>' : tr_html += '<option value="22">0% | IVA  | Isento nos termos da alínea c) do artigo 15.º do CIVA</option>'; 
                        (item_tax == 23) ? tr_html += '<option selected="selected" value="23">0% | IVA | Isento nos termos da alinea d) do nº1 do artigo 14.º</option>' : tr_html += '<option value="23">0% | IVA  | Isento nos termos da alinea d) do nº1 do artigo 14.º</option>';
                        (item_tax == 24) ? tr_html += '<option selected="selected" value="24">0% | IVA | Isento nos termos da alínea d) do artigo 15.º do CIVA</option>' : tr_html += '<option value="24">0% | IVA  | Isento nos termos da alínea d) do artigo 15.º do CIVA</option>';
                        (item_tax == 25) ? tr_html += '<option selected="selected" value="25">0% | IVA | Isento nos termos da alínea e) do artigo 15.º do CIVA</option>' : tr_html += '<option value="25">0% | IVA  | Isento nos termos da alínea e) do artigo 15.º do CIVA</option>';
                        (item_tax == 26) ? tr_html += '<option selected="selected" value="26">0% | IVA | Isento nos termos da alínea f) do artigo 15.º do CIVA</option>' : tr_html += '<option value="26">0% | IVA  | Isento nos termos da alínea f) do artigo 15.º do CIVA</option>';
                        (item_tax == 27) ? tr_html += '<option selected="selected" value="27">0% | IVA | Isento nos termos da alínea g) do artigo 15.º do CIVA</option>' : tr_html += '<option value="27">0% | IVA  | Isento nos termos da alínea g) do artigo 15.º do CIVA</option>';
                        (item_tax == 30) ? tr_html += '<option selected="selected" value="30">5% | IVA | Regime Geral 5%</option>' : tr_html += '<option value="30">5% | IVA | Regime Geral 5%</option>';
                        (item_tax == 31) ? tr_html += '<option selected="selected" value="31">7% | IVA | Regime Geral 7%</option>' : tr_html += '<option value="31">7% | IVA | Regime Geral 7%</option></select></td>';
        tr_html += '<td style="padding:2px;"><input class="form-control input-sm kb-pad text-center rquantity" name="quantity[]" type="text" value="' + item_qty + '" data-id="' + row_no + '" data-item="' + item_id + '" id="quantity_' + row_no + '" onClick="this.select();"></td>';            
        tr_html += '<td style="padding:2px; min-width:80px;"><input class="form-control input-sm kb-pad text-center rcost" name="cost[]" type="text" value="' + item_cost + '" data-id="' + row_no + '" data-item="' + item_id + '" id="cost_' + row_no + '" onClick="this.select();"></td>';
        tr_html += '<td style="padding:2px; min-width:40px;"><input class="form-control input-sm kb-pad text-center rdiscount" name="discount[]" type="text" value="'+ item_discount +'" data-id="' + row_no + '" data-item="' + item_id + '" id="discount_' + row_no + '" onClick="this.select();"></td>';
       var sub_total = null, row_val = 0;
       if (item_tax == 1) {
        row_val = (parseFloat(item_cost) * parseFloat(item_qty)) - parseFloat((parseFloat(item_cost) * parseFloat(item_qty)) * item_discount / 100);
        row_val = row_val + row_val* 14 / 100;
        sub_total = formatMoney(row_val);
        tr_html += '<td class="text-right"><span class="text-right ssubtotal" id="subtotal_' + row_no + '">' + sub_total + '</span></td>';
    } else if (item_tax == 30) {
        row_val = (parseFloat(item_cost) * parseFloat(item_qty)) - parseFloat((parseFloat(item_cost) * parseFloat(item_qty)) * item_discount / 100);
        row_val = row_val + row_val* 5 / 100;
        sub_total = formatMoney(row_val);
        tr_html += '<td class="text-right"><span class="text-right ssubtotal" id="subtotal_' + row_no + '">' + sub_total + '</span></td>';

    } else if (item_tax == 31) {
        row_val = (parseFloat(item_cost) * parseFloat(item_qty)) - parseFloat((parseFloat(item_cost) * parseFloat(item_qty)) * item_discount / 100);
        row_val = row_val + row_val* 7 / 100;
        sub_total = formatMoney(row_val);
        tr_html += '<td class="text-right"><span class="text-right ssubtotal" id="subtotal_' + row_no + '">' + sub_total + '</span></td>';
    } else {
        row_val = (parseFloat(item_cost) * parseFloat(item_qty)) - parseFloat((parseFloat(item_cost) * parseFloat(item_qty)) * item_discount / 100);
        sub_total = formatMoney(row_val);
        tr_html += '<td class="text-right"><span class="text-right ssubtotal" id="subtotal_' + row_no + '">' + sub_total + '</span></td>';
    }
        tr_html += '<td class="text-center"><i class="fa fa-trash-o tip pointer spodel" id="reset" title="Remove"></i></td>';
        //document.getElementById("tax_id").selectedIndex  = item_id;
        newTr.html(tr_html);
        newTr.prependTo("#poTable");
        total += row_val;
        
    });

   // grand_total = formatMoney(total);       
    $("#gtotal").text(formatMoney(total));
    $('#add_item').focus();
}
}

function add_order_item(item) {

var item_id = Settings.item_addition == 1 ? item.item_id : item.id;
if (spoitems[item_id]) {
    spoitems[item_id].row.qty = parseFloat(spoitems[item_id].row.qty) + 1;
} else {
    spoitems[item_id] = item;
}

store('spoitems', JSON.stringify(spoitems));
loadItems();
return true;
}