// nif_autofill.robust.js v3
// Aceita NIF alfanumérico do MinFin: 9 dígitos + até 6 alfanuméricos (ex.: 003136359BA043)
// Procura o campo NIF mesmo sem ID (#cf1, name=cf1, #vat_no, #nif, ou pelo <label>NIF>)
// Liga ao abrir QUALQUER modal e dispara imediatamente
(function () {
  function $(sel, root){ return (root || document).querySelector(sel); }
  function $all(sel, root){ return Array.prototype.slice.call((root||document).querySelectorAll(sel)); }
  function setIfEmpty(el,v){ if(el && String(el.value||'').trim()==='') el.value=v||''; }
  function setAlways(el,v){ if(el) el.value=v||''; }
  function token9Plus(s){
    // 9 dígitos seguidos de até 6 [A-Za-z0-9] contíguos
    var m = String(s||'').toUpperCase().match(/[0-9]{9}[A-Z0-9]{0,6}/);
    return m ? m[0] : '';
  }
  function debounce(fn, ms){ var t; return function(){ var c=this,a=arguments; clearTimeout(t); t=setTimeout(function(){ fn.apply(c,a); }, ms||350); }; }
  function findNif(root){
    var sels = ['#cf1','input[name="cf1"]','#vat_no','input[name="vat_no"]','#nif','input[name="nif"]'];
    for(var i=0;i<sels.length;i++){ var el=$(sels[i],root); if(el) return el; }
    var labels = $all('label', root);
    for(var j=0;j<labels.length;j++){
      if(/^\s*nif\s*:?\s*$/i.test(labels[j].textContent)){
        var group = labels[j].closest('.form-group') || labels[j].parentNode;
        var inp = (group && group.querySelector('input')) || labels[j].parentNode.querySelector('input');
        if(inp) return inp;
      }
    }
    return null;
  }

  window.initNifAutoFill = function (opts) {
    var o = Object.assign({
      name:'#cname', email:'#cemail', phone:'#cphone',
      address:'#bairro', municipio:'#cidade', provincia:'#estado', pais:'#Country',
      endpoint:'/api/taxpayer', modalSelector:'.modal', debug:true
    }, opts||{});
    function log(){ if(o.debug && window.console) console.log.apply(console, ['[NIF-AutoFill]'].concat([].slice.call(arguments))); }

    function fillFromData(payload, ctx){
      var d = (payload && (payload.data || payload)) || {};
      var nome = d.companyName || d.gsmc || d.nameAbb || 'Consumidor final';
      var phone = d.lxfs || '';
      var email = (d.email && /.+@.+\..+/.test(String(d.email))) ? d.email : '';
      var address = d.addressSbbb || d.nsrdz || '';
      var municipio = d.city || '';
      var provincia = d.province || '';
      var pais = d.country || 'Angola';
      setAlways($(o.name,ctx), nome);
      if (phone)   setIfEmpty($(o.phone,ctx), phone);
      if (email)   setIfEmpty($(o.email,ctx), email);
      if (address) setIfEmpty($(o.address,ctx), address);
      if (municipio) setIfEmpty($(o.municipio,ctx), municipio);
      if (provincia) setIfEmpty($(o.provincia,ctx), provincia);
      setIfEmpty($(o.pais,ctx), pais);
      log('Preenchido:', {nome:nome, phone:phone, email:email});
    }

    function bind(ctx){
      var root = ctx || document;
      var nifEl = findNif(root) || findNif(document);
      if(!nifEl){ log('Campo NIF não encontrado.'); return; }

      var doLookup = debounce(function(){
        var raw = nifEl.value;
        var nif = token9Plus(raw);
        if(!nif){ log('Valor sem padrão 9+alfa:', raw); return; }
        // Consumidor final aplica-se só a 9 dígitos exatos
        if (nif === '999999999') { fillFromData({data:{companyName:'Consumidor final', country:'Angola'}}, root); return; }
        var url = o.endpoint + (o.endpoint.indexOf('?')===-1 ? '?' : '&') + 'nif='+encodeURIComponent(nif);
        log('Consultar:', url);
        fetch(url, {method:'GET', credentials:'same-origin'})
          .then(function(r){ return r.json().catch(function(){ return {}; }); })
          .then(function(j){
            if (j && (j.success || (j.data && (j.data.companyName || j.data.gsmc || j.data.nameAbb)))) {
              fillFromData(j, root);
            } else {
              log('Resposta inesperada:', j);
            }
          })
          .catch(function(e){ log('Erro fetch:', e); });
      }, 350);

      ['input','change','blur','keyup'].forEach(function(ev){ nifEl.addEventListener(ev, doLookup); });
      setTimeout(doLookup, 80);
      log('Ligado ao NIF:', nifEl);
    }

    if (window.jQuery && jQuery(document).on){
      jQuery(document).on('shown.bs.modal', o.modalSelector, function(){ bind(this); });
    }
    setTimeout(function(){ bind(); }, 200);
  };
})();
