// nif_autofill.js (patched)
// - dispara a pesquisa IMEDIATAMENTE se já houver 9 dígitos
// - faz lookup quando o modal #add-customer for aberto
(function () {
  function $(sel) { return document.querySelector(sel); }
  function setIfEmpty(sel, val) {
    var el = $(sel); if (!el) return;
    if (String(el.value || '').trim() === '') el.value = val || '';
  }
  function setAlways(sel, val) {
    var el = $(sel); if (el) el.value = val || '';
  }
  function onlyDigits(s){ return (s || '').replace(/\D+/g,''); }
  function debounce(fn, ms) {
    var t; return function() {
      var ctx = this, args = arguments;
      clearTimeout(t); t = setTimeout(function(){ fn.apply(ctx, args); }, ms || 400);
    };
  }

  window.initNifAutoFill = function (opts) {
    var o = Object.assign({
      nif: '#customer_nif',
      name: '#customer_name',
      email: '#customer_email',
      phone: '#customer_phone',
      address: '#customer_address',
      municipio: '#customer_municipio',
      provincia: '#customer_provincia',
      pais: '#customer_pais',
      endpoint: '/themes/default/views/taxpayer_proxy.php',
      modal: '#add-customer'
    }, opts || {});

    function fillFromData(data) {
      var d = data && (data.data || data) || {};
      var nome = d.companyName || d.gsmc || 'Consumidor final';
      setAlways(o.name, nome);
      setIfEmpty(o.email, d.email || '');
      setIfEmpty(o.address, d.address || d.addressSbbb || '');
      setIfEmpty(o.municipio, d.city || '');
      setIfEmpty(o.provincia, d.province || '');
      setIfEmpty(o.pais, d.country || 'Angola');
    }
    function localConsumerFill() {
      setAlways(o.name, 'Consumidor final');
      setIfEmpty(o.pais, 'Angola');
    }

    var nifInput = $(o.nif);
    if (!nifInput) { console.warn('initNifAutoFill: NIF input não encontrado:', o.nif); return; }

    var doLookup = debounce(function () {
      var nif = onlyDigits(nifInput.value);
      if (nif.length !== 9) return;

      if (nif === '999999999') { localConsumerFill(); return; }

      fetch(o.endpoint + '?nif=' + encodeURIComponent(nif), { method: 'GET', credentials: 'same-origin' })
        .then(function (r) { return r.json(); })
        .then(function (j) {
          if (j && (j.success || (j.data && (j.data.companyName || j.data.gsmc)))) {
            fillFromData(j);
          } else {
            console.warn('NIF não encontrado na API.', j);
          }
        })
        .catch(function (e) { console.error('Erro ao consultar NIF:', e); });
    }, 400);

    ['change','blur','keyup'].forEach(function (ev) {
      nifInput.addEventListener(ev, doLookup);
    });

    // Disparar IMEDIATO se o campo já veio preenchido com 9 dígitos
    setTimeout(function(){ doLookup(); }, 50);

    // Quando o modal for aberto, tentar novamente (garante que os campos estão no DOM)
    var modal = $(o.modal);
    if (modal && typeof jQuery !== 'undefined' && jQuery(modal).on) {
      jQuery(modal).on('shown.bs.modal', function(){ doLookup(); });
    }
  };
})();
