<?php
/**
 * Teste de verificação: SAF-T AO bloqueia envio AGT
 */

$host = 'localhost';
$user = 'root';
$pass = '';
$dbname = 'wpv_modelo';

$conn = new mysqli($host, $user, $pass, $dbname);

if ($conn->connect_error) {
    die("Erro de conexão: " . $conn->connect_error);
}

echo "<h2>Teste: Bloqueio AGT com SAF-T AO</h2>";

// Verificar valor atual
$result = $conn->query("SELECT tipo_faturacao FROM tec_settings WHERE setting_id = 1");
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $tipo_atual = $row['tipo_faturacao'];
    
    echo "<p><strong>Tipo de Faturação atual:</strong> <span style='color:blue;'>" . ($tipo_atual ?: 'NULL') . "</span></p>";
    
    if ($tipo_atual === 'SAF-T AO') {
        echo "<p style='color:green;'><strong>✓ SAF-T AO ativado</strong></p>";
        echo "<p>Quando tentar enviar uma fatura para AGT, o sistema retornará:</p>";
        echo "<pre style='background:#f0f0f0; padding:10px;'>";
        echo json_encode(array(
            'ok' => true,
            'http_code' => 200,
            'skipped' => true,
            'message' => 'Tipo de faturação é SAF-T AO. Envio para AGT desativado.'
        ), JSON_PRETTY_PRINT);
        echo "</pre>";
        
        echo "<p><strong>Comportamento esperado:</strong></p>";
        echo "<ul>";
        echo "<li>✓ Faturas são criadas normalmente no sistema</li>";
        echo "<li>✓ Numeração continua funcionando (FT, FR, NC, etc.)</li>";
        echo "<li>✓ <strong>NÃO</strong> envia para AGT (Administração Geral Tributária)</li>";
        echo "<li>✓ Gera apenas SAF-T AO para exportação manual</li>";
        echo "</ul>";
        
    } else if ($tipo_atual === 'Faturação Eletronica') {
        echo "<p style='color:orange;'><strong>⚠ Faturação Eletrónica ativada</strong></p>";
        echo "<p>O sistema <strong>ENVIARÁ</strong> faturas para AGT automaticamente.</p>";
        
        echo "<p><strong>Para desativar envio AGT:</strong></p>";
        echo "<ol>";
        echo "<li>Vá para <a href='settings'>Settings</a></li>";
        echo "<li>Selecione <strong>SAF-T AO</strong> no campo 'Tipo de Faturação'</li>";
        echo "<li>Clique em Guardar</li>";
        echo "</ol>";
    }
    
} else {
    echo "<p style='color:red;'>❌ Erro: Não foi possível ler tipo_faturacao</p>";
}

echo "<hr>";
echo "<h3>Código implementado em Agt.php:</h3>";
echo "<pre style='background:#f0f0f0; padding:10px; font-size:12px;'>";
echo htmlspecialchars("
// Verificar se tipo de faturação é SAF-T AO (não envia para AGT)
\$settings = \$this->db->get_where('settings', array('setting_id' => 1))->row();
if (\$settings && isset(\$settings->tipo_faturacao) && \$settings->tipo_faturacao === 'SAF-T AO') {
    return \$this->_json(array(
        'ok'=>true,
        'http_code'=>200,
        'skipped'=>true,
        'message'=>'Tipo de faturação é SAF-T AO. Envio para AGT desativado.'
    ));
}
");
echo "</pre>";

$conn->close();

echo "<hr>";
echo "<p><a href='settings'>Ir para Settings</a> | <a href='sales'>Ir para Vendas</a></p>";
?>
