<!DOCTYPE html>
<html>
<head>
    <title>Teste AGT - Listar Séries</title>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1000px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; }
        .btn { padding: 12px 24px; background: #3498db; color: white; border: none; cursor: pointer; border-radius: 5px; margin: 10px 0; }
        .success { background: #27ae60; color: white; padding: 15px; margin: 15px 0; border-radius: 5px; }
        .error { background: #e74c3c; color: white; padding: 15px; margin: 15px 0; border-radius: 5px; }
        .warning { background: #f39c12; color: white; padding: 15px; margin: 15px 0; border-radius: 5px; }
        pre { background: #2c3e50; color: #00ff00; padding: 15px; border-radius: 5px; overflow-x: auto; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; text-align: left; border: 1px solid #ddd; }
        th { background: #3498db; color: white; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔍 Teste: Listar Séries AGT</h1>
        
        <p>Este script testa directamente o endpoint <code>/agt/listar_series</code></p>
        
        <button class="btn" onclick="testarAgt()">Testar Agora</button>
        
        <div id="loading" style="display:none;" class="warning">
            ⏳ A consultar a AGT... aguarde...
        </div>
        
        <div id="result"></div>
        
        <h2>Console de Debug</h2>
        <pre id="console"></pre>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        function log(msg) {
            var console = document.getElementById('console');
            console.textContent += '[' + new Date().toLocaleTimeString() + '] ' + msg + '\n';
        }

        function testarAgt() {
            log('Iniciando teste...');
            
            document.getElementById('loading').style.display = 'block';
            document.getElementById('result').innerHTML = '';
            
            var url = 'agt/listar_series?send=1&establishmentNumber=1&debug=1';
            log('URL: ' + url);
            
            $.ajax({
                url: url,
                method: 'GET',
                dataType: 'json',
                timeout: 30000,
                success: function(resp) {
                    log('Resposta recebida!');
                    document.getElementById('loading').style.display = 'none';
                    
                    console.log('Resposta completa:', resp);
                    
                    var html = '<div class="success"><h3>✅ Sucesso!</h3></div>';
                    
                    // Mostrar dados principais
                    html += '<h3>Informações da Resposta:</h3>';
                    html += '<ul>';
                    html += '<li><strong>ok:</strong> ' + resp.ok + '</li>';
                    html += '<li><strong>http_code:</strong> ' + resp.http_code + '</li>';
                    html += '</ul>';
                    
                    // Mostrar séries encontradas
                    if (resp.uniqueByType && Object.keys(resp.uniqueByType).length > 0) {
                        html += '<h3>✅ Séries Encontradas:</h3>';
                        html += '<table>';
                        html += '<tr><th>Tipo</th><th>Código</th><th>Ano</th><th>Estado</th><th>Próximo Número</th></tr>';
                        
                        for (var tipo in resp.uniqueByType) {
                            var s = resp.uniqueByType[tipo];
                            html += '<tr>';
                            html += '<td><strong>' + tipo + '</strong></td>';
                            html += '<td>' + (s.seriesCode || '-') + '</td>';
                            html += '<td>' + (s.seriesYear || '-') + '</td>';
                            html += '<td>' + (s.seriesStatus || '-') + '</td>';
                            html += '<td>' + (s.nextNumber || '-') + '</td>';
                            html += '</tr>';
                        }
                        html += '</table>';
                        
                        log('Séries encontradas: ' + Object.keys(resp.uniqueByType).join(', '));
                    } else {
                        html += '<div class="warning">⚠️ Nenhuma série encontrada em uniqueByType</div>';
                        log('ATENÇÃO: uniqueByType está vazio!');
                    }
                    
                    // Resposta RAW completa
                    html += '<h3>Resposta Completa (JSON):</h3>';
                    html += '<pre>' + JSON.stringify(resp, null, 2) + '</pre>';
                    
                    document.getElementById('result').innerHTML = html;
                },
                error: function(xhr, status, error) {
                    log('ERRO: ' + error);
                    document.getElementById('loading').style.display = 'none';
                    
                    var html = '<div class="error">';
                    html += '<h3>❌ Erro na Consulta</h3>';
                    html += '<p><strong>Status:</strong> ' + status + '</p>';
                    html += '<p><strong>Erro:</strong> ' + error + '</p>';
                    html += '<p><strong>HTTP Status:</strong> ' + xhr.status + '</p>';
                    html += '<h4>Resposta do Servidor:</h4>';
                    html += '<pre>' + xhr.responseText + '</pre>';
                    html += '</div>';
                    
                    document.getElementById('result').innerHTML = html;
                }
            });
        }
        
        log('Página carregada. Clique no botão para testar.');
    </script>
</body>
</html>
