-- Script para adicionar colunas de séries AGT à tabela tec_settings
-- Execute este script se os campos de séries não estiverem a aparecer

-- Verificar se as colunas já existem
SELECT COLUMN_NAME 
FROM INFORMATION_SCHEMA.COLUMNS 
WHERE TABLE_SCHEMA = 'wpv_modelo' 
  AND TABLE_NAME = 'tec_settings' 
  AND COLUMN_NAME LIKE '%-seriesCode';

-- Se não existirem, adicionar as colunas:
ALTER TABLE `tec_settings` 
ADD COLUMN IF NOT EXISTS `FT-seriesCode` VARCHAR(50) DEFAULT NULL COMMENT 'Série para Facturas',
ADD COLUMN IF NOT EXISTS `FR-seriesCode` VARCHAR(50) DEFAULT NULL COMMENT 'Série para Facturas Recibo',
ADD COLUMN IF NOT EXISTS `GF-seriesCode` VARCHAR(50) DEFAULT NULL COMMENT 'Série para Guias de Transporte',
ADD COLUMN IF NOT EXISTS `NC-seriesCode` VARCHAR(50) DEFAULT NULL COMMENT 'Série para Notas de Crédito',
ADD COLUMN IF NOT EXISTS `RC-seriesCode` VARCHAR(50) DEFAULT NULL COMMENT 'Série para Recibos',
ADD COLUMN IF NOT EXISTS `RG-seriesCode` VARCHAR(50) DEFAULT NULL COMMENT 'Série para Recibo de Pagamento';

-- Verificar se foram adicionadas
SHOW COLUMNS FROM `tec_settings` WHERE Field LIKE '%-seriesCode';
