<?php
ob_start();
session_start();
require_once('../../../../config/config.php');
require_once('../../../../config/crud.php');
require_once('../../../../config/funcoes.php');

if(!$_SESSION['autUser']){
    header('Location: ' . PAINELLOGIN);
    exit;
}

// Processar limpeza de logs
$message = '';
$messageType = '';

if(!empty($_POST['clear_license_alerts'])){
    $logFile = BASEPATH . '../logs/license_alerts.log';
    if(file_exists($logFile)){
        if(file_put_contents($logFile, '') !== false){
            $message = 'License alerts log foi limpo com sucesso!';
            $messageType = 'success';
        } else {
            $message = 'Erro ao limpar o license alerts log.';
            $messageType = 'danger';
        }
    } else {
        $message = 'Arquivo license_alerts.log não encontrado.';
        $messageType = 'warning';
    }
}

// Obter informações sobre os logs
$logFile = BASEPATH . '../logs/license_alerts.log';
$logFileSize = file_exists($logFile) ? filesize($logFile) : 0;
$logFileLastModified = file_exists($logFile) ? date('Y-m-d H:i:s', filemtime($logFile)) : 'N/A';

?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Utilitários - <?php echo SITENOME; ?> - Painel</title>
    <link rel="icon" type="image/ico" href="../../favicon.ico"/>
    
    <link href="../../css/stylesheets.css" rel="stylesheet" type="text/css" />
    <script type='text/javascript' src='../../js/jquery/jquery.min.js'></script>
    <script type='text/javascript' src='../../js/bootstrap/bootstrap.min.js'></script>
    <script type='text/javascript' src='../../js/plugins.js'></script>
    <script type='text/javascript' src='../../js/actions.js'></script>
</head>
<body>
    <div id="wrapper">
        <div id="header">
            <div class="wrap">
                <a href="<?php echo PAINEL; ?>/index" class="logo"></a>
                <div class="buttons fl">
                    <div class="item">
                        <a href="#" class="btn btn-primary btn-sm c_layout">
                            <span class="i-layout-8"></span>
                        </a>
                    </div>
                </div>
                <div class="buttons">
                    <div class="item">
                        <a href="<?php echo PAINEL; ?>/logoff" class="btn btn-primary btn-sm">
                            <span class="i-exit"></span> Sair
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div id="left">
            <?php include('../../inc/menu.php'); ?>
        </div>

        <div id="content">
            <div class="wrap">
                <div class="content-header">
                    <h1>Utilitários do Sistema</h1>
                </div>

                <div class="content-inner">
                    <?php if(!empty($message)): ?>
                        <div class="alert alert-<?php echo $messageType; ?> alert-dismissable">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <strong><?php echo ucfirst($messageType); ?>!</strong> <?php echo $message; ?>
                        </div>
                    <?php endif; ?>

                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h3 class="panel-title">
                                <span class="i-folder-open"></span> Gerenciamento de Logs
                            </h3>
                        </div>
                        <div class="panel-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="well">
                                        <h4>License Alerts Log</h4>
                                        <p>
                                            <strong>Caminho:</strong><br>
                                            <small><?php echo $logFile; ?></small>
                                        </p>
                                        <p>
                                            <strong>Tamanho:</strong> 
                                            <span class="label label-info">
                                                <?php 
                                                if($logFileSize == 0) {
                                                    echo 'Vazio';
                                                } elseif($logFileSize < 1024) {
                                                    echo $logFileSize . ' B';
                                                } elseif($logFileSize < 1024*1024) {
                                                    echo round($logFileSize / 1024, 2) . ' KB';
                                                } else {
                                                    echo round($logFileSize / (1024*1024), 2) . ' MB';
                                                }
                                                ?>
                                            </span>
                                        </p>
                                        <p>
                                            <strong>Última modificação:</strong><br>
                                            <small><?php echo $logFileLastModified; ?></small>
                                        </p>
                                        <hr>
                                        <form method="post" style="display: inline;">
                                            <button type="submit" name="clear_license_alerts" value="1" class="btn btn-danger" onclick="return confirm('Tem certeza que deseja limpar o license alerts log? Esta ação não pode ser desfeita.');">
                                                <span class="i-trash"></span> Limpar License Alerts Log
                                            </button>
                                        </form>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="well">
                                        <h4>Informações do Sistema</h4>
                                        <p>
                                            <strong>PHP Version:</strong> 
                                            <span class="label label-default"><?php echo phpversion(); ?></span>
                                        </p>
                                        <p>
                                            <strong>Sistema Operacional:</strong> 
                                            <span class="label label-default"><?php echo php_uname(); ?></span>
                                        </p>
                                        <p>
                                            <strong>OpenSSL:</strong> 
                                            <span class="label <?php echo extension_loaded('openssl') ? 'label-success' : 'label-danger'; ?>">
                                                <?php echo extension_loaded('openssl') ? '✓ Carregado' : '✗ Não carregado'; ?>
                                            </span>
                                        </p>
                                        <p>
                                            <strong>cURL:</strong> 
                                            <span class="label <?php echo extension_loaded('curl') ? 'label-success' : 'label-danger'; ?>">
                                                <?php echo extension_loaded('curl') ? '✓ Carregado' : '✗ Não carregado'; ?>
                                            </span>
                                        </p>
                                        <p>
                                            <strong>Memória Disponível:</strong> 
                                            <span class="label label-default"><?php echo ini_get('memory_limit'); ?></span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
