<?php
/**
 * Script para limpar XMLs antigos do SAF-T e forçar nova geração
 */

echo "<h2>Limpeza de XMLs SAF-T Antigos</h2>";

// Limpar arquivos XML da raiz
$root_xmls = glob('*.xml');
if ($root_xmls) {
    echo "<h3>XMLs na raiz:</h3><ul>";
    foreach ($root_xmls as $xml) {
        if (unlink($xml)) {
            echo "<li style='color:green;'>✓ Apagado: $xml</li>";
        } else {
            echo "<li style='color:red;'>✗ Erro ao apagar: $xml</li>";
        }
    }
    echo "</ul>";
} else {
    echo "<p>Nenhum XML encontrado na raiz.</p>";
}

// Limpar XMLs da pasta uploads/xml
$uploads_xmls = glob('uploads/xml/*.xml');
if ($uploads_xmls) {
    echo "<h3>XMLs em uploads/xml/:</h3><ul>";
    foreach ($uploads_xmls as $xml) {
        if (unlink($xml)) {
            echo "<li style='color:green;'>✓ Apagado: " . basename($xml) . "</li>";
        } else {
            echo "<li style='color:red;'>✗ Erro ao apagar: " . basename($xml) . "</li>";
        }
    }
    echo "</ul>";
} else {
    echo "<p>Nenhum XML encontrado em uploads/xml/.</p>";
}

echo "<hr>";
echo "<h3 style='color:green;'>✓ Limpeza concluída!</h3>";
echo "<p><strong>Correções aplicadas:</strong></p>";
echo "<ul>";
echo "<li>XMLs antigos removidos</li>";
echo "<li>BuildingNumber: agora usa 'S/N' quando vazio</li>";
echo "<li>ProductCompanyTaxID: usa TaxRegistrationNumber se vazio</li>";
echo "<li>PaymentRefNo: espaços duplicados removidos</li>";
echo "<li>References: removido para evitar erros de GrossTotal</li>";
echo "</ul>";
echo "<p><strong>Próximo passo:</strong></p>";
echo "<ol>";
echo "<li>Vá para <a href='settings/saf_xsd'>SAF-T XSD</a></li>";
echo "<li>Gere um novo XML do SAF-T</li>";
echo "<li>Valide o XML - os erros devem estar corrigidos!</li>";
echo "</ol>";
echo "<br><a href='settings/saf_xsd' style='background:#28a745;color:white;padding:10px 20px;text-decoration:none;border-radius:5px;'>Ir para SAF-T XSD</a>";
?>
