<!DOCTYPE html>
<html>
<head>
    <title>Diagnóstico e Correção - Séries AGT</title>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            margin: 0;
            padding: 20px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
        }
        h1 {
            color: #2c3e50;
            border-bottom: 3px solid #3498db;
            padding-bottom: 10px;
        }
        h2 {
            color: #34495e;
            margin-top: 30px;
        }
        .status {
            padding: 15px;
            margin: 15px 0;
            border-radius: 5px;
            font-weight: bold;
        }
        .success {
            background: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }
        .error {
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }
        .warning {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            color: #856404;
        }
        .info {
            background: #d1ecf1;
            border: 1px solid #bee5eb;
            color: #0c5460;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background: #3498db;
            color: white;
        }
        tr:nth-child(even) {
            background: #f2f2f2;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            background: #3498db;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 10px 5px;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover {
            background: #2980b9;
        }
        .btn-success {
            background: #27ae60;
        }
        .btn-success:hover {
            background: #229954;
        }
        .btn-danger {
            background: #e74c3c;
        }
        .btn-danger:hover {
            background: #c0392b;
        }
        pre {
            background: #2c3e50;
            color: #00ff00;
            padding: 15px;
            border-radius: 5px;
            overflow-x: auto;
        }
        .step {
            background: #ecf0f1;
            padding: 15px;
            margin: 10px 0;
            border-left: 4px solid #3498db;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Diagnóstico e Correção - Séries AGT</h1>
        
        <?php
        error_reporting(E_ALL);
        ini_set('display_errors', 1);

        // Ler configuração da base de dados do ficheiro config
        require_once __DIR__ . '/app/config/database.php';
        
        $host = DB_HOST;
        $user = DB_USER;
        $pass = DB_PASS;
        $db = DB_NAME;

        $conn = new mysqli($host, $user, $pass, $db);

        if ($conn->connect_error) {
            echo "<div class='status error'>❌ Erro de conexão: " . $conn->connect_error . "</div>";
            exit;
        }

        echo "<div class='status success'>✅ Conexão com a base de dados estabelecida</div>";

        // PASSO 1: Verificar se as colunas existem
        echo "<h2>📋 Passo 1: Verificar Estrutura da Tabela</h2>";
        
        $series_columns = ['FT-seriesCode', 'FR-seriesCode', 'GF-seriesCode', 'NC-seriesCode', 'RC-seriesCode'];
        $missing_columns = [];
        
        foreach ($series_columns as $col) {
            $sql = "SHOW COLUMNS FROM `tec_settings` LIKE '" . $conn->real_escape_string($col) . "'";
            $result = $conn->query($sql);
            
            if ($result && $result->num_rows > 0) {
                echo "<div class='status success'>✅ Coluna `{$col}` existe</div>";
            } else {
                echo "<div class='status error'>❌ Coluna `{$col}` NÃO existe</div>";
                $missing_columns[] = $col;
            }
        }

        // PASSO 2: Adicionar colunas em falta (se houver)
        if (!empty($missing_columns)) {
            echo "<h2>🔨 Passo 2: Adicionar Colunas em Falta</h2>";
            echo "<div class='info'>A adicionar " . count($missing_columns) . " coluna(s)...</div>";
            
            foreach ($missing_columns as $col) {
                $sql = "ALTER TABLE `tec_settings` ADD COLUMN `{$col}` VARCHAR(50) DEFAULT NULL";
                if ($conn->query($sql)) {
                    echo "<div class='status success'>✅ Coluna `{$col}` adicionada com sucesso</div>";
                } else {
                    echo "<div class='status error'>❌ Erro ao adicionar `{$col}`: " . $conn->error . "</div>";
                }
            }
        } else {
            echo "<h2>✅ Passo 2: Todas as Colunas Existem</h2>";
        }

        // PASSO 3: Verificar valores actuais
        echo "<h2>📊 Passo 3: Valores Actuais na Base de Dados</h2>";
        
        $sql = "SELECT 
            `FT-seriesCode`,
            `FR-seriesCode`,
            `GF-seriesCode`,
            `NC-seriesCode`,
            `RC-seriesCode`,
            TaxRegistrationNumber
        FROM tec_settings 
        LIMIT 1";

        $result = $conn->query($sql);

        if ($result && $result->num_rows > 0) {
            $row = $result->fetch_assoc();
            
            echo "<table>";
            echo "<tr><th>Campo</th><th>Valor Actual</th><th>Estado</th></tr>";
            
            $all_empty = true;
            foreach ($series_columns as $col) {
                $value = isset($row[$col]) ? $row[$col] : '';
                $is_empty = empty($value) || is_null($value);
                
                if (!$is_empty) {
                    $all_empty = false;
                }
                
                $status = $is_empty ? 
                    '<span style="color:red;">❌ VAZIO</span>' : 
                    '<span style="color:green;">✅ ' . htmlspecialchars($value) . '</span>';
                
                echo "<tr>";
                echo "<td><strong>{$col}</strong></td>";
                echo "<td>" . ($is_empty ? '<em>(NULL/vazio)</em>' : htmlspecialchars($value)) . "</td>";
                echo "<td>{$status}</td>";
                echo "</tr>";
            }
            
            echo "</table>";
            
            echo "<p><strong>NIF:</strong> " . htmlspecialchars($row['TaxRegistrationNumber']) . "</p>";
            
        } else {
            echo "<div class='status error'>❌ Nenhum registo encontrado em tec_settings!</div>";
            $all_empty = true;
        }

        // PASSO 4: Testar consulta AGT
        echo "<h2>🌐 Passo 4: Teste de Consulta AGT</h2>";
        
        echo "<div class='step'>";
        echo "<p><strong>O botão 'Consultar Séries (AGT) e Guardar' faz o seguinte:</strong></p>";
        echo "<ol>";
        echo "<li>Chama o endpoint: <code>" . $_SERVER['REQUEST_SCHEME'] . "://" . $_SERVER['HTTP_HOST'] . "/wpv_modelo/agt/listar_series?send=1&establishmentNumber=1</code></li>";
        echo "<li>A AGT devolve as séries registadas para o seu NIF</li>";
        echo "<li>O JavaScript preenche os campos automaticamente</li>";
        echo "<li>Se os campos estiverem vazios na BD, grava pela primeira vez</li>";
        echo "</ol>";
        echo "</div>";
        
        if ($all_empty) {
            echo "<div class='status warning'>";
            echo "<p><strong>⚠️ ACÇÃO NECESSÁRIA:</strong></p>";
            echo "<p>Os campos estão vazios. Agora pode:</p>";
            echo "<ol>";
            echo "<li>Voltar à página de Settings: <a href='/wpv_modelo/settings' class='btn'>Ir para Settings</a></li>";
            echo "<li>Clicar no botão <strong>'Consultar Séries (AGT) e Guardar'</strong></li>";
            echo "<li>O sistema vai buscar as séries e gravar automaticamente</li>";
            echo "</ol>";
            echo "</div>";
        } else {
            echo "<div class='status success'>";
            echo "<p><strong>✅ As séries já estão preenchidas!</strong></p>";
            echo "<p>Se precisa actualizá-las, pode:</p>";
            echo "<ol>";
            echo "<li>Limpar os valores manualmente (SQL abaixo)</li>";
            echo "<li>Ou editá-los directamente na página de Settings</li>";
            echo "</ol>";
            echo "</div>";
            
            echo "<h3>SQL para Limpar Séries (se necessário):</h3>";
            echo "<pre>";
            echo "UPDATE `tec_settings` SET \n";
            foreach ($series_columns as $col) {
                echo "  `{$col}` = NULL,\n";
            }
            echo "WHERE 1=1;";
            echo "</pre>";
        }

        // PASSO 5: Verificar JavaScript
        echo "<h2>🔍 Passo 5: Verificar Console do Navegador</h2>";
        echo "<div class='step'>";
        echo "<p>Se o botão não funciona, abra o <strong>Console do Navegador</strong> (F12) e procure por erros.</p>";
        echo "<p>Erros comuns:</p>";
        echo "<ul>";
        echo "<li><code>ENDPOINT_SERIES is not defined</code> - problema no JavaScript</li>";
        echo "<li><code>404 Not Found</code> - rota AGT não configurada</li>";
        echo "<li><code>Unauthorized</code> ou <code>403</code> - problema de autenticação AGT</li>";
        echo "<li>Erro de assinatura JWS - chaves privadas AGT não configuradas</li>";
        echo "</ul>";
        echo "</div>";

        $conn->close();
        ?>

        <h2>🎯 Próximos Passos</h2>
        <div class="step">
            <ol>
                <li>Certifique-se que as colunas existem (verificado acima ✅)</li>
                <li>Vá para <a href="/wpv_modelo/settings" class="btn">Settings</a></li>
                <li>Clique em <strong>"Consultar Séries (AGT) e Guardar"</strong></li>
                <li>Verifique o Console do Navegador (F12) para ver a resposta</li>
                <li>Se houver erro, copie a mensagem e reporte</li>
            </ol>
        </div>

        <div style="text-align:center; margin-top:30px;">
            <a href="/wpv_modelo/settings" class="btn btn-success">Ir para Settings</a>
            <a href="/wpv_modelo/check_series.php" class="btn">Verificar Estado Actual</a>
        </div>
    </div>
</body>
</html>
