<?php
require __DIR__.'/app/config/database.php';
require __DIR__.'/app/helpers/database_helper.php';

// Simple diagnostic to see what values are in tec_settings and tec_customers for addresses/building numbers

header('Content-Type: text/plain; charset=utf-8');

echo "=== tec_settings (setting_id=1) ===\n";
$settings = get_row('tec_settings', ['setting_id' => 1]);
if ($settings) {
    $fields = ['BuildingNumber','StreetName','AddressDetail','City','Province','Country','PostalCode','CompanyID','TaxRegistrationNumber','CompanyName','BusinessName'];
    foreach ($fields as $f) {
        $val = isset($settings[$f]) ? $settings[$f] : '';
        echo str_pad($f, 25, ' ').": ".$val."\n";
    }
} else {
    echo "tecs_settings setting_id=1 not found\n";
}

echo "\n=== tec_customers (first 5) ===\n";
$customers = get_rows('tec_customers', [], 'id ASC', 5);
foreach ($customers as $c) {
    echo "id=".$c['id']." name=".$c['name']." numero=".$c['numero']." bairro=".$c['bairro']." cidade=".$c['cidade']." province=".$c['province']." postal_code=".$c['postal_code']."\n";
}

echo "\nNota: Header do SAF-T usa tec_settings.*, não tec_customers. Se BuildingNumber aparecer com outro valor, é porque tec_settings.BuildingNumber tem esse valor.\n";
