<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sales_model extends CI_Model
{
	
	public function __construct() {
		parent::__construct();

	}

	/* === VENDAS / SALES BÁSICO ========================================== */

	public function getSaleByID($id)
    {
        // Devolve a linha completa da tabela sales, incluindo os campos AGT
        // (agt_request_id, agt_submitted_at, agt_last_status, agt_error_json, etc.)
        $q = $this->db->get_where('sales', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }
	
	public function deleteInvoice($id) {
		// if($this->db->delete('sale_items', array('sale_id' => $id)) && $this->db->delete('sales', array('id' => $id))) {
		// 	return true;
		// }
        $sale = $this->db->get_where("sales", array("id"=>$id))->row_array();
        if($sale['InvoiceType'] != "FP"){
            $this->db->where(array('sale_id' => $id));
            $sale_items = $this->db->get("sale_items")->result_array();
            foreach ($sale_items as $key => $sale_item) {
                $product = $this->db->get_where("products",array("id"=>$sale_item['product_id']))->row_array();
                $quantity =  $product['quantity'] + $sale_item['quantity'];
                $this->db->update('products', array('quantity' => $quantity),  array('id' => $sale_item['product_id']));
            }
        }
        $this->db->update("payments",array("PaymentStatus"=>"A"), array("sale_id"=>$id));
        $this->db->update("sales",array("InvoiceStatus"=>"A"), array("id"=>$id));
		return TRUE;
	}

	public function deleteOpenedSale($id) {
		if($this->db->delete('suspended_items', array('suspend_id' => $id)) && $this->db->delete('suspended_sales', array('id' => $id
		
		))) {
			return true;
		}
		return FALSE;
	}
	
	/* === PAGAMENTOS ===================================================== */

	public function getSalePayments($sale_id)
    {
        $this->db->order_by('id', 'asc');
        $q = $this->db->get_where('payments', array('sale_id' => $sale_id));
        if ($q->num_rows() > 0) {
            foreach (($q->result()) as $row) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function getPaymentByID($id)
    {
        $q = $this->db->get_where('payments', array('id' => $id), 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return FALSE;
    }

    public function addPayment($data = array())
    {
        if ($this->db->insert('payments', $data)) {
            if ($data['paid_by'] == 'gift_card') {
                $gc = $this->site->getGiftCardByNO($data['gc_no']);
                $this->db->update('gift_cards', array('balance' => ($gc->balance - $data['amount'])), array('card_no' => $data['gc_no']));
            }

            $this->syncSalePayments($data['sale_id']);
            return true;
        }
        return false;
    }

    public function updatePayment($id, $data = array())
    {
        if ($this->db->update('payments', $data, array('id' => $id))) {
            $this->syncSalePayments($data['sale_id']);
            return true;
        }
        return false;
    }

    public function deletePayment($id)
    {   
        $opay = $this->getPaymentByID($id);

        if ($this->db->delete('payments', array('id' => $id))) {
            $this->syncSalePayments($opay->sale_id);
            return true;
        }
        return FALSE;
    }

    public function syncSalePayments($id)
    {
        $sale = $this->getSaleByID($id);
        $payments = $this->getSalePayments($id);
        $paid = 0;
        if($payments) {
        	foreach ($payments as $payment) {
        		$paid += $payment->amount;
        	}
        }
        $status = $paid <= 0 ? 'due' : $sale->status;
	    if ($this->tec->formatDecimal($sale->grand_total) > $this->tec->formatDecimal($paid) && $paid > 0) {
            $status = 'partial';
        } elseif ($this->tec->formatDecimal($sale->grand_total) <= $this->tec->formatDecimal($paid)) {
            $status = 'paid';
        }

        if ($this->db->update('sales', array('paid' => $paid, 'status' => $status), array('id' => $id))) {
            return true;
        }

        return FALSE;
    }

    /* ====================================================================
     * === BLOCO NOVO: FUNÇÕES DE APOIO AO INTEGRAÇÃO AGT =================
     * ==================================================================== */

    /**
     * Lista vendas com informação de estado AGT para usar em relatórios / datatables.
     *
     * Exemplo de uso no controller:
     *   $sales = $this->Sales_model->getSalesWithAgtStatus(50, 0, array('agt_last_status' => 'ENVIADO'));
     */
    public function getSalesWithAgtStatus($limit = 50, $offset = 0, $filters = array())
    {
        $this->db
            ->select('
                id,
                date,
                customer_id,
                customer_name,
                grand_total,
                status,
                InvoiceNo,
                InvoiceType,
                agt_request_id,
                agt_submitted_at,
                agt_last_status,
                agt_error_json
            ')
            ->from('sales');

        // Filtros opcionais
        if (!empty($filters['date_from'])) {
            $this->db->where('date >=', $filters['date_from'] . ' 00:00:00');
        }
        if (!empty($filters['date_to'])) {
            $this->db->where('date <=', $filters['date_to'] . ' 23:59:59');
        }
        if (!empty($filters['customer_id'])) {
            $this->db->where('customer_id', (int) $filters['customer_id']);
        }
        if (!empty($filters['agt_last_status'])) {
            $this->db->where('agt_last_status', $filters['agt_last_status']);
        }

        $this->db->order_by('id', 'DESC');
        $this->db->limit($limit, $offset);

        $q = $this->db->get();
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return array();
    }

    /**
     * Atualiza de forma centralizada os campos de estado AGT de uma venda.
     *
     * Isto é útil para o Agt.php chamar:
     *
     *   $this->Sales_model->setAgtStatus($sale_id, 'ENVIADO', $submissionUUID, null);
     */
    public function setAgtStatus($sale_id, $status, $request_id = null, $error_json = null)
    {
        $data = array(
            'agt_last_status' => $status,
        );

        if ($request_id !== null) {
            $data['agt_request_id'] = $request_id;
        }

        if ($error_json !== null) {
            $data['agt_error_json'] = $error_json;
        }

        // Se ainda não tiver data de submissão e está a ser enviado agora, regista timestamp
        if (!empty($request_id) && empty($sale->agt_submitted_at)) {
            $data['agt_submitted_at'] = date('Y-m-d H:i:s');
        }

        $this->db->where('id', (int) $sale_id);
        return $this->db->update('sales', $data);
    }
}
