<?php
/**
 * API helper simples (PHP 5.6 compatível)
 * - POST JSON via cURL
 * - Suporta Basic Auth
 */
class Api
{
    public static function post_json($url, $bodyArr, $username, $password, $headers = array(), $timeout = 60, $debug = false)
    {
        if (!is_array($headers)) $headers = array();

        $headers[] = 'Accept: application/json';
        $headers[] = 'Content-Type: application/json; charset=utf-8';

        $body = json_encode($bodyArr, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);

        $ch = curl_init($url);
        curl_setopt_array($ch, array(
            CURLOPT_POST            => true,
            CURLOPT_POSTFIELDS      => $body,
            CURLOPT_RETURNTRANSFER  => true,
            CURLOPT_HTTPAUTH        => CURLAUTH_BASIC,
            CURLOPT_USERPWD         => $username . ':' . $password,
            CURLOPT_HTTPHEADER      => $headers,
            CURLOPT_TIMEOUT         => (int)$timeout,

            // evita problemas com 100-continue em alguns proxies
            CURLOPT_HTTP_VERSION    => CURL_HTTP_VERSION_1_1,
        ));

        // SSL: em produção deve estar true e com CA correcto.
        // Em HML às vezes falha em ambientes Windows antigos.
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

        if ($debug) {
            curl_setopt($ch, CURLOPT_VERBOSE, true);
        }

        $respBody = curl_exec($ch);
        $code     = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $err      = curl_error($ch);
        $info     = curl_getinfo($ch);
        curl_close($ch);

        return array(
            'ok'        => ($code >= 200 && $code < 300),
            'http_code' => $code,
            'body'      => $respBody,
            'error'     => $err,
            '_debug'    => array(
                'url'  => $url,
                'sent' => $body,
                'info' => $info,
            )
        );
    }
}
