<?php defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('agt_status_badge')) {
    /**
     * Devolve um badge Bootstrap com o estado AGT.
     *
     * @param string|null $status  valor de tec_sales.agt_last_status
     * @return string HTML <span>
     */
    function agt_status_badge($status)
    {
        $raw = trim((string)$status);
        $s   = strtoupper($raw);

        $class = 'label-default';
        $text  = 'Sem envio';

        if ($s === '' || $s === 'PENDING_PAYLOAD') {
            $class = 'label-warning';
            $text  = 'Por enviar';
        }

        switch ($s) {
            case 'ENVIADO':
            case 'OBTER_ESTADO_OK':
                $class = 'label-info';
                $text  = 'Enviado';
                break;

            case 'ACEITE':
            case 'APROVADO':
            case 'VALIDADO':
                $class = 'label-success';
                $text  = 'Aprovado';
                break;

            case 'REJEITADO':
            case 'RECUSADO':
            case 'ERRO_HTTP':
            case 'OBTER_ESTADO_ERRO':
                $class = 'label-danger';
                $text  = 'Erro / Rejeitado';
                break;

            case 'WEBHOOK':
                $class = 'label-primary';
                $text  = 'Actualizado (webhook)';
                break;
        }

        // Mostra também o valor bruto no title (tooltip)
        $title = $raw !== '' ? 'AGT: ' . $raw : 'AGT: sem estado';

        return '<span class="label ' . $class . '" title="' . htmlspecialchars($title, ENT_QUOTES, 'UTF-8') . '">' .
               htmlspecialchars($text, ENT_QUOTES, 'UTF-8') .
               '</span>';
    }
    
}
