<?php defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Controller extends CI_Controller {

    function __construct() {
        parent::__construct();
        
        // ========== PROTEÇÃO DE INTEGRIDADE DO SISTEMA ==========
        // Verifica se arquivos críticos foram modificados
        $integrity_file = FCPATH . '.system_integrity';
        if (file_exists($integrity_file)) {
            require_once(APPPATH . 'core/Security_check.php');
            if (!Security_check::verify_integrity() || !Security_check::verify_license_function_exists()) {
                header('HTTP/1.1 503 Service Unavailable');
                die('<h1>Sistema Indisponível</h1><p>Detectada modificação não autorizada. Contacte o suporte técnico.</p><!-- Code: SEC_TAMPER -->');
            }
        }
        // ========================================================
        
        define("DEMO", 0);
        $this->Settings = $this->site->getSettings();
        $this->lang->load('app', $this->Settings->language);
        $this->Settings->pin_code = $this->Settings->pin_code ? md5($this->Settings->pin_code) : NULL;
        $this->theme = $this->Settings->theme.'/views/';
        $this->data['assets'] = base_url() . 'themes/default/assets/';
        $this->data['Settings'] = $this->Settings;
        $this->loggedIn = $this->tec->logged_in();
        $this->data['loggedIn'] = $this->loggedIn;
        $this->data['categories'] = $this->site->getAllCategories();
        $this->Admin = $this->tec->in_group('admin') || $this->tec->in_group('super_admin') ? TRUE : NULL;
        $this->Comercial = $this->tec->in_group('comercial')  ? TRUE : NULL;
        $this->Staff = $this->tec->in_group('staff') ? TRUE : NULL;
        $this->Super_admin = $this->tec->in_group('super_admin')  ?  TRUE : NULL;
        $this->data['Admin'] = $this->Admin;
        $this->data['Comercial'] = $this->Comercial;
		$this->Garson = $this->tec->in_group('garson') ? TRUE : NULL;
		$this->data['garson'] = $this->Garson;
        $this->m = strtolower($this->router->fetch_class());
        $this->v = strtolower($this->router->fetch_method());
        $this->data['m']= $this->m;
        $this->data['v'] = $this->v;
        

    }

    function page_construct($page, $data = array(), $meta = array()) {
        if(empty($meta)) { $meta['page_title'] = $data['page_title']; }
        $meta['message'] = isset($data['message']) ? $data['message'] : $this->session->flashdata('message');
        $meta['error'] = isset($data['error']) ? $data['error'] : $this->session->flashdata('error');
        $meta['warning'] = isset($data['warning']) ? $data['warning'] : $this->session->flashdata('warning');
        // If no flash warning, check for persistent license alerts file and show latest alert to admins
        if (empty($meta['warning'])) {
            $alert_file = APPPATH . '../logs/license_alerts.log';
            if (file_exists($alert_file) && is_readable($alert_file)) {
                $lines = file($alert_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                if ($lines && is_array($lines)) {
                    $last = trim(end($lines));
                    if ($last) {
                        $meta['warning'] = $last;
                    }
                }
            }
        }
        $meta['ip_address'] = $this->input->ip_address();
        $meta['Admin'] = $data['Admin'];
        $meta['Garson'] = $data['garson'];
        $meta['Staff'] = $data['staff'];
        $meta['Comercial'] = $data['Comercial'];
        $meta['loggedIn'] = $data['loggedIn'];
        $meta['Settings'] = $data['Settings'];
        $meta['assets'] = $data['assets'];
        $meta['suspended_sales'] = $this->site->getUserSuspenedSales();
        $meta['qty_alert_num'] = $this->site->getQtyAlerts();
        $this->load->view($this->theme . 'header', $meta);
        $this->load->view($this->theme . $page, $data);
        $this->load->view($this->theme . 'footer');
    }

}
 