<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Utilities extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        
        // Verifica se é admin
        if (!$this->loggedIn) {
            redirect('login');
        }

        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
    }

    public function index()
    {
        // Processar limpeza de logs
        $message = '';
        $messageType = '';

        if (!empty($_POST['clear_license_alerts'])) {
            $logFile = APPPATH . '../logs/license_alerts.log';
            if (file_exists($logFile)) {
                if (file_put_contents($logFile, '') !== false) {
                    $message = 'License alerts log foi limpo com sucesso!';
                    $messageType = 'success';
                } else {
                    $message = 'Erro ao limpar o license alerts log.';
                    $messageType = 'danger';
                }
            } else {
                $message = 'Arquivo license_alerts.log não encontrado.';
                $messageType = 'warning';
            }
        }

        // Obter informações sobre os logs
        $logFile = APPPATH . '../logs/license_alerts.log';
        $logFileSize = file_exists($logFile) ? filesize($logFile) : 0;
        $logFileLastModified = file_exists($logFile) ? date('Y-m-d H:i:s', filemtime($logFile)) : 'N/A';

        // NÃO sobrescreva $this->data — ele já contém chaves necessárias
        // do MY_Controller (como 'assets', 'Settings', etc.). Apenas atribua.
        $this->data['message'] = $message;
        $this->data['messageType'] = $messageType;
        $this->data['logFile'] = $logFile;
        $this->data['logFileSize'] = $logFileSize;
        $this->data['logFileLastModified'] = $logFileLastModified;

        $this->data['page_title'] = 'Utilitários';
        $bc = array(array('link' => '#', 'page' => 'Utilitários'));
        $meta = array('page_title' => 'Utilitários', 'bc' => $bc);
        
        $this->page_construct('utilities/index', $this->data, $meta);
    }
}
