<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

require realpath(__DIR__) . '/../../vendor/autoload.php';
include realpath(__DIR__) . '/../core/Func.php';
include realpath(__DIR__) . '/../core/Redirect.php';

class Printer extends MY_Controller {

    function __construct() {
        parent::__construct();
        if (!$this->loggedIn) {
            redirect('login');
        }
        $this->load->model('printer_model');
        $this->load->library('form_validation');
        $this->load->helper('database_helper');
    }

    /*
     * Listing of printers
     */

    function index_default() {
        if($this->session->userdata("settings")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        // $params['limit'] = RECORDS_PER_PAGE;
        $params['offset'] = ($this->input->get('per_page')) ? $this->input->get('per_page') : 0;

        $config = $this->config->item('pagination');
        $config['base_url'] = site_url('printer/index?');
        $config['total_rows'] = $this->Printer_model->get_all_printers_count();
        $this->pagination->initialize($config);

        $data['printers'] = $this->Printer_model->get_all_printers($params);

        $data['_view'] = 'printer/index';
        //$this->load->view('layouts/main',$data);
        $this->load->view($this->theme . 'printer/index', $this->data);
    }

    function index() {
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('Printers');
        $bc = array(array('link' => '#', 'page' => lang('Printers')));
        $meta = array('page_title' => lang('Printers'), 'bc' => $bc);
        $this->page_construct('printer/index', $this->data, $meta);
    }

    function index_old() {
        $data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('products');
        $bc = array(array('link' => '#', 'page' => lang('products')));
        $meta = array('page_title' => lang('products'), 'bc' => $bc);
        $this->page_construct('products/index', $this->data, $meta);
    }

    /*
     * Adding a new printer
     */

    function add() {
        if($this->session->userdata("settings")!=1){
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }
        //$this->load->library('form_validation');

        $this->form_validation->set_rules('title', 'Title', 'required|max_length[255]');
        $this->form_validation->set_rules('type', 'Type', 'required|max_length[255]');
        $this->form_validation->set_rules('profile', 'Profile', 'required|max_length[255]');
        $this->form_validation->set_rules('chars_per_line', 'Chars Per Line', 'required|integer');
        //$this->form_validation->set_rules('ip_address', 'Ip Address', 'required|max_length[50]');
        //$this->form_validation->set_rules('port', 'Port', 'required|integer');

        if ($this->form_validation->run()) {
            $params = array(
                'type' => $this->input->post('type'),
                'profile' => $this->input->post('profile'),
                'title' => $this->input->post('title'),
                'chars_per_line' => $this->input->post('chars_per_line'),
                'ip_address' => $this->input->post('ip_address'),
                'port' => $this->input->post('port'),
                'path' => $this->input->post('path'),
                'date_created' => date("Y-m-d H:i:s"),
            );
          
            $printer_id = $this->printer_model->add_printer($params);
            if (!empty($printer_id)) {
                $this->session->set_flashdata('message', "Printer added successfully!");
                redirect('printer/index');
            } else {
                $this->data['error'] = "Unable to save printer";
                // $this->data['categories'] = $this->site->getAllCategories();
                $this->data['page_title'] = "Add printer";
                $bc = array(array('link' => site_url('printers'), 'page' => lang('printers')), array('link' => '#', 'page' => lang('Add Printer')));
                $meta = array('page_title' => lang('Add Printer'), 'bc' => $bc);
                $this->page_construct('printer/add', $this->data, $meta);
            }
        } else {
            //$data['_view'] = 'printer/add';
            // $this->load->view('layouts/main',$data);
            //$this->load->view($this->theme . 'printer/index', $data);            
            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            // $this->data['categories'] = $this->site->getAllCategories();
            $this->data['page_title'] = "Add printer";
            $this->session->set_flashdata('error', $this->data['error']);
            $bc = array(array('link' => site_url('printers'), 'page' => lang('printers')), array('link' => '#', 'page' => lang('Add Printer')));
            $meta = array('page_title' => lang('Add Printer'), 'bc' => $bc);
            $this->page_construct('printer/add', $this->data, $meta);
        }
    }

    function add_productsss() {
        if (!$this->Admin) {
            $this->session->set_flashdata('error', lang('access_denied'));
            redirect('pos');
        }

        $this->form_validation->set_rules('code', lang("product_code"), 'trim|is_unique[products.code]|min_length[2]|max_length[50]|required|alpha_numeric');
        $this->form_validation->set_rules('name', lang("product_name"), 'required');
        $this->form_validation->set_rules('UnitOfMeasure', lang("UnitOfMeasure"), 'required');
        $this->form_validation->set_rules('category', lang("category"), 'required');
        $this->form_validation->set_rules('price', lang("product_price"), 'required|is_numeric');
        $this->form_validation->set_rules('cost', lang("product_cost"), 'required|is_numeric');
        $this->form_validation->set_rules('tax_id', lang("product_tax"), 'required|is_numeric');
        $this->form_validation->set_rules('quantity', lang("quantity"), 'is_numeric');
        $this->form_validation->set_rules('alert_quantity', lang("alert_quantity"), 'is_numeric');

        if ($this->form_validation->run() == true) {

            $tax_info = get_row("tec_tax", array("id" => $this->input->post('tax_id')));
            $data = array(
                'type' => $this->input->post('type'),
                'code' => $this->input->post('code'),
                'name' => $this->input->post('name'),
                'category_id' => $this->input->post('category'),
                'price' => $this->input->post('price'),
                'cost' => $this->input->post('cost'),
                'tax' => $tax_info['tax'],
                'tax_id' => $this->input->post('tax_id'),
                'tax_type' => $tax_info['tax_type'],
                'tax_method' => $tax_info['metodo'],
                'validity_date' => $this->input->post('validity_date'),
                'quantity' => $this->input->post('quantity'),
                'alert_quantity' => $this->input->post('alert_quantity'),
                'details' => $this->input->post('details'),
                'UnitOfMeasure' => $this->input->post('UnitOfMeasure'),
            );

            if ($this->input->post('type') == 'combo') {
                $c = sizeof($_POST['combo_item_code']) - 1;
                for ($r = 0; $r <= $c; $r++) {
                    if (isset($_POST['combo_item_code'][$r]) && isset($_POST['combo_item_quantity'][$r])) {
                        $items[] = array(
                            'item_code' => $_POST['combo_item_code'][$r],
                            'quantity' => $_POST['combo_item_quantity'][$r]
                        );
                    }
                }
            } else {
                $items = array();
            }

            if ($_FILES['userfile']['size'] > 0) {

                $this->load->library('upload');

                $config['upload_path'] = 'uploads/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size'] = '500';
                $config['max_width'] = '800';
                $config['max_height'] = '800';
                $config['overwrite'] = FALSE;
                $config['encrypt_name'] = TRUE;
                $this->upload->initialize($config);

                if (!$this->upload->do_upload()) {
                    $error = $this->upload->display_errors();
                    $this->session->set_flashdata('error', $error);
                    redirect("products/add", 'refresh');
                }

                $photo = $this->upload->file_name;
                $data['image'] = $photo;

                $this->load->library('image_lib');
                $config['image_library'] = 'gd2';
                $config['source_image'] = 'uploads/' . $photo;
                $config['new_image'] = 'uploads/thumbs/' . $photo;
                $config['maintain_ratio'] = TRUE;
                $config['width'] = 110;
                $config['height'] = 110;

                $this->image_lib->clear();
                $this->image_lib->initialize($config);

                if (!$this->image_lib->resize()) {
                    $this->session->set_flashdata('error', $this->image_lib->display_errors());
                    redirect("products/add");
                }
            }
            // $this->tec->print_arrays($data, $items);
        }

        if ($this->form_validation->run() == true && $this->products_model->addProduct($data, $items)) {

            $this->session->set_flashdata('message', lang("product_added"));
            redirect('products');
        } else {

            $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
            $this->data['categories'] = $this->site->getAllCategories();
            $this->data['page_title'] = lang('add_product');
            $bc = array(array('link' => site_url('products'), 'page' => lang('products')), array('link' => '#', 'page' => lang('add_product')));
            $meta = array('page_title' => lang('add_product'), 'bc' => $bc);
            $this->page_construct('products/add', $this->data, $meta);
        }
    }

    /*
     * Editing a printer
     */

    function edit($printer_id) {
        // check if the printer exists before trying to edit it
        $data['printer'] = $this->Printer_model->get_printer($printer_id);

        if (isset($data['printer']['printer_id'])) {
            $this->load->library('form_validation');

            $this->form_validation->set_rules('title', 'Title', 'required|max_length[255]');
            $this->form_validation->set_rules('type', 'Type', 'required|max_length[255]');
            $this->form_validation->set_rules('profile', 'Profile', 'required|max_length[255]');
            $this->form_validation->set_rules('chars_per_line', 'Chars Per Line', 'required|integer');
            $this->form_validation->set_rules('ip_address', 'Ip Address', 'required|max_length[50]');
            $this->form_validation->set_rules('port', 'Port', 'required|integer');

            if ($this->form_validation->run()) {
                $params = array(
                    'type' => $this->input->post('type'),
                    'profile' => $this->input->post('profile'),
                    'title' => $this->input->post('title'),
                    'chars_per_line' => $this->input->post('chars_per_line'),
                    'ip_address' => $this->input->post('ip_address'),
                    'port' => $this->input->post('port'),
                );

                $this->Printer_model->update_printer($printer_id, $params);
                redirect('printer/index');
            } else {
                $data['_view'] = 'printer/edit';
                $this->load->view('layouts/main', $data);
            }
        } else {
            show_error('The printer you are trying to edit does not exist.');
        }
    }

    /*
     * Deleting printer
     */

    function remove($printer_id) {
        $printer = $this->Printer_model->get_printer($printer_id);

        // check if the printer exists before trying to delete it
        if (isset($printer['printer_id'])) {
            $this->Printer_model->delete_printer($printer_id);
            redirect('printer/index');
        } else {
            show_error('The printer you are trying to delete does not exist.');
        }
    }

    function get_printers() {
        /* if ( ! $this->Admin) {
          $this->session->set_flashdata('error', lang('access_denied'));
          redirect('pos');
          } */
        $this->load->library('datatables');
        $this->datatables->select("printer_id,date_created, title, profile,type, chars_per_line, ip_address, port");
        $this->datatables->from('printers');
        //$this->datatables->add_column("Actions", "<div class='text-center'><div class='btn-group'><a onclick=\"window.open('" . site_url('printer/view/$1') . "', 'pos_popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0'); return false;\" href='#' title='" . lang('print_barcodes') . "' class='tip btn btn-primary btn-xs'><i class='fa fa-file-text-o'></i></a> <a href='" . site_url('printer/edit/$1') . "' title='" . lang("Edit Printer") . "' class='tip btn btn-warning btn-xs'><i class='fa fa-edit'></i></a> <a href='" . site_url('printer/delete/$1') . "' onClick=\"return confirm('" . lang('alert_x_purchase') . "')\" title='" . lang("Delete Printer?") . "' class='tip btn btn-danger btn-xs'><i class='fa fa-trash-o'></i></a></div></div>", "printer_id");
        $this->datatables->unset_column('printer_id');
       // $this->datatables->unset_column('chars_per_line');
        echo $this->datatables->generate();
    }

}
