<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|   example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|   http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|   $route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|   $route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|   $route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples: my-controller/index -> my_controller/index
|       my-controller/my-method -> my_controller/my_method
*/
$route['default_controller'] = 'welcome';
$route['404_override'] = '';;
$route['translate_uri_dashes'] = FALSE;

$route['login'] = 'auth/login';
$route['logout'] = 'auth/logout';
$route['users'] = 'auth/users';
$route['users/profile/(:num)'] = 'auth/profile/$1';
$route['users/add'] = 'auth/create_user';

$route['pos/(:num)'] = 'pos1/index/$1';
$route['saft/validate'] = 'SaftValidator/index';
$route['api/taxpayer'] = 'api/taxpayer';


$route['api/taxpayer']              = 'api/taxpayer';
$route['api/taxpayer/(:any)']      = 'api/taxpayer/$1';

$route['api/consultar-nif']        = 'api/consultar_nif_cliente';
$route['api/consultar-nif/(:any)'] = 'api/consultar_nif_cliente/$1';

// Compatibilidade: mapear chamadas antigas para o novo controller Api_sif
$route['api/get_license_by_nif'] = 'api_sif/get_license_by_nif';
$route['api/register_logged_status'] = 'api_sif/register_logged_status';

$route['Agt/obter_estado/(:num)'] = 'Agt/obter_estado/$1';
$route['Agt/registar_factura/(:num)'] = 'Agt/registar_factura/$1';


$route['Agt/listar_facturas'] = 'agt/listar_facturas';
$route['Agt/consultar_factura'] = 'agt/consultar_factura';
$route['Agt/test_cfg'] = 'agt/test_cfg';
