<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->lang->load('auth', $this->Settings->language);
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));
        $this->load->model('auth_model');
        $this->load->library('ion_auth');
    }

    function index() {
        if (!$this->loggedIn) {
            redirect('login');
        } elseif($this->Admin) {
            redirect('admin');
		} elseif($this->staff) {
            redirect('staff');
        } else {
            redirect('login');
        }
    }

    function users() {
        if (!$this->loggedIn) {
            redirect('login');
        }
        if (!$this->Admin) {
            $this->session->set_flashdata('warning', lang("access_denied"));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        $this->data['groups'] = $this->ion_auth->groups()->result_array();
        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['users'] = $this->site->getAllUsers();
        $bc = array(array('link' => '#', 'page' => lang('users')));
        $meta = array('page_title' => lang('users'), 'bc' => $bc);
        $this->data['page_title'] = lang('users');
        $this->page_construct('auth/index', $this->data, $meta);
		
		
    }

    function profile($id = NULL) {
        if (!$this->ion_auth->logged_in() || !$this->Admin && $id != $this->session->userdata('user_id')) {
            $this->session->set_flashdata('warning', lang("access_denied"));
            redirect($_SERVER["HTTP_REFERER"]);
        }
        if (!$id || empty($id)) {
            redirect('auth');
        }

        $this->data['title'] = lang('profile');

        $user = $this->ion_auth->user($id)->row();
        $groups = $this->ion_auth->groups()->result_array();
        $this->data['csrf'] = $this->_get_csrf_nonce();
        $this->data['user'] = $user;
        $this->data['groups'] = $groups;

        $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
        $this->data['password'] = array(
            'name' => 'password',
            'id' => 'password',
            'class' => 'form-control',
            'type' => 'password',
            'value' => ''
            );
        $this->data['password_confirm'] = array(
            'name' => 'password_confirm',
            'id' => 'password_confirm',
            'class' => 'form-control',
            'type' => 'password',
            'value' => ''
            );
        $this->data['min_password_length'] = $this->config->item('min_password_length', 'ion_auth');
        $this->data['old_password'] = array(
            'name' => 'old',
            'id' => 'old',
            'class' => 'form-control',
            'type' => 'password',
            );
        $this->data['new_password'] = array(
            'name' => 'new',
            'id' => 'new',
            'type' => 'password',
            'class' => 'form-control',
            'pattern' => '^.{' . $this->data['min_password_length'] . '}.*$',
            );
        $this->data['new_password_confirm'] = array(
            'name' => 'new_confirm',
            'id' => 'new_confirm',
            'type' => 'password',
            'class' => 'form-control',
            'pattern' => '^.{' . $this->data['min_password_length'] . '}.*$',
            );
        $this->data['user_id'] = array(
            'name' => 'user_id',
            'id' => 'user_id',
            'type' => 'hidden',
            'value' => $user->id,
            );

        $this->data['id'] = $id;

        $this->data['page_title'] = lang('profile');
        $bc = array(array('link' => site_url('users'), 'page' => lang('users')), array('link' => '#', 'page' => lang('profile')));
        $meta = array('page_title' => lang('profile'), 'bc' => $bc);
        $this->page_construct('auth/profile', $this->data, $meta);
    }

    public function captcha_check($cap) {
        $expiration = time() - 300; // 5 minutes limit
        $this->db->query("DELETE FROM captcha WHERE captcha_time < " . $expiration);

        $sql = "SELECT COUNT(*) AS count FROM captcha WHERE word = ? AND ip_address = ? AND captcha_time > ?";
        $binds = array($cap, $this->input->ip_address(), $expiration);
        $query = $this->db->query($sql, $binds);
        $row = $query->row();
        if ($row->count == 0) {
            $this->form_validation->set_message('captcha_check', lang('captcha_wrong'));
            return FALSE;
        } else {
            return TRUE;
        }
    }

    //log the user in
    function login($m = NULL) {
        if($this->Settings->captcha) {
            $this->form_validation->set_rules('captcha', lang('captcha'), 'required|callback_captcha_check');
        }

        if ($this->form_validation->run() == true) {
            $remember = (bool) $this->input->post('remember');
            if ($this->ion_auth->login($this->input->post('identity'), $this->input->post('password'), $remember)) {
                if ($this->Settings->mmode) {
                    if (!$this->ion_auth->in_group('admin')) {
                        $this->session->set_flashdata('error', lang('site_is_offline_plz_try_later'));
                        redirect('auth/logout');
                    }
                }

                $this->session->set_flashdata('message', $this->ion_auth->messages());
                $referrer = $this->session->userdata('requested_page') ? $this->session->userdata('requested_page') : '';
                $postParameter = array(
                    'logged_status' =>1,
                    'logged_ip' => getHostByName(getHostName()),
                    'TaxRegistrationNumber'=>$this->Settings->TaxRegistrationNumber,
                    'licence'=>$this->Settings->licence
                );
                $curlHandle = curl_init('https://mc.sifpos.ao/api/register_logged_status');
                curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
                curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
                
                $curlResponse = curl_exec($curlHandle);
                $http_code = curl_getinfo($curlHandle, CURLINFO_HTTP_CODE);
                curl_close($curlHandle);
                // Log the register call for debugging
                $log_file = APPPATH . '../logs/license_checks.log';
                $now = date('Y-m-d H:i:s');
                $resp_snippet = substr($curlResponse, 0, 500);
                @file_put_contents($log_file, "[$now] NIF={$this->Settings->TaxRegistrationNumber} - posted logged_status=1 HTTP={$http_code} RESP=" . str_replace("\n", ' ', $resp_snippet) . "\n", FILE_APPEND|LOCK_EX);
                
                // verify remote licence after successful login; block if invalid
                $lic_ok = $this->verify_remote_license();
                if ($lic_ok !== true) {
                    // Salvar erro em cookie antes de fazer logout (que destrói a sessão)
                    $error_msg = $this->session->flashdata('error');
                    if ($error_msg) {
                        setcookie('license_error', $error_msg, time()+60, '/');
                    }
                    $this->ion_auth->logout();
                    redirect('auth/login');
                }
                redirect($referrer);
            } else {
                $this->session->set_flashdata('error', $this->ion_auth->errors());
                redirect('auth/login');
            }
        } else {

            // Verificar se há erro de licença no cookie
            $cookie_error = isset($_COOKIE['license_error']) ? $_COOKIE['license_error'] : '';
            if ($cookie_error) {
                // Apagar o cookie após ler
                setcookie('license_error', '', time()-3600, '/');
                $this->data['error'] = $cookie_error;
            } else {
                $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
            }
            $this->data['message'] = $this->session->flashdata('message');
            if($this->Settings->captcha) {
                $this->load->helper('captcha');
                $vals = array(
                    'img_path' => './assets/captcha/',
                    'img_url' => site_url() . 'assets/captcha/',
                    'img_width' => 150,
                    'img_height' => 34,
                    );
                $cap = create_captcha($vals);
                $capdata = array(
                    'captcha_time' => $cap['time'],
                    'ip_address' => $this->input->ip_address(),
                    'word' => $cap['word']
                    );

                $query = $this->db->insert_string('captcha', $capdata);
                $this->db->query($query);
                $this->data['image'] = $cap['image'];
                $this->data['captcha'] = array('name' => 'captcha',
                    'id' => 'captcha',
                    'type' => 'text',
                    'class' => 'form-control',
                    'required' => 'required',
                    'placeholder' => lang('type_captcha')
                    );
            }
            $this->data['page_title'] = lang('login');

            $this->load->view($this->theme.'auth/login', $this->data);
        }
       
    }
    function staff($m = NULL) {
        $this->form_validation->set_rules('password', lang("password"), 'trim|required');
        $this->form_validation->set_rules('identity', lang("password"), 'trim|required');
        $this->form_validation->set_rules('group_id', lang("group"), 'trim|required');
        if ($this->form_validation->run() == true) {
            $remember = (bool) $this->input->post('remember');
            if ($this->ion_auth->staff_login($this->input->post('identity'),$this->input->post('password'), $this->input->post('group_id'), $remember)) {
                if ($this->Settings->mmode) {
                    if (!$this->ion_auth->in_group('admin')) {
                        $this->session->set_flashdata('error', lang('site_is_offline_plz_try_later'));
                        redirect('auth/logout');
                    }
                }
                $this->session->set_flashdata('message', $this->ion_auth->messages());
                $referrer = $this->session->userdata('requested_page') ? $this->session->userdata('requested_page') : '';
                // verify remote licence for staff login as well; block if invalid
                $lic_ok = $this->verify_remote_license();
                if ($lic_ok !== true) {
                    // Salvar erro em cookie antes de fazer logout
                    $error_msg = $this->session->flashdata('error');
                    if ($error_msg) {
                        setcookie('license_error', $error_msg, time()+60, '/');
                    }
                    $this->ion_auth->logout();
                    redirect('auth/staff');
                }
                redirect('pos');
            } else {
                $this->session->set_flashdata('error', $this->ion_auth->errors());
                redirect('auth/staff');
            }
        }else{
            // Verificar se há erro de licença no cookie
            $cookie_error = isset($_COOKIE['license_error']) ? $_COOKIE['license_error'] : '';
            if ($cookie_error) {
                setcookie('license_error', '', time()-3600, '/');
                $this->data['error'] = $cookie_error;
            } else {
                $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
            }
            $this->data['message'] = $this->session->flashdata('message');
            $this->data["staffs"] = $this->ion_auth->getstaff();
            $this->data['page_title'] = lang('login');
            $this->load->view($this->theme.'auth/staff', $this->data);
        }
    }

    function reload_captcha(){
        $this->load->helper('captcha');
        $vals = array(
            'img_path' => './assets/captcha/',
            'img_url' => site_url() . 'assets/captcha/',
            'img_width' => 150,
            'img_height' => 34,
            );
        $cap = create_captcha($vals);
        $capdata = array(
            'captcha_time' => $cap['time'],
            'ip_address' => $this->input->ip_address(),
            'word' => $cap['word']
            );
        $query = $this->db->insert_string('captcha', $capdata);
        $this->db->query($query);

        echo $cap['image'];
    }

    function logout($m = NULL) {
        $group_id = $this->session->group_id;
        $logout = $this->ion_auth->logout();
        $postParameter = array(
            'logged_status' =>0,
            'logged_ip' => getHostByName(getHostName()),
            'TaxRegistrationNumber'=>$this->Settings->TaxRegistrationNumber,
            'licence'=>$this->Settings->licence
        );
        $curlHandle = curl_init('https://mc.sifpos.ao/api/register_logged_status');
        curl_setopt($curlHandle, CURLOPT_POSTFIELDS, $postParameter);
        curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
        
        $curlResponse = curl_exec($curlHandle);
        curl_close($curlHandle);
        $this->session->set_flashdata('message', $this->ion_auth->messages());
        if($group_id==base64_encode(2)){
            redirect('auth/staff/'.$m);
        }else{
             redirect('auth/login/'.$m);
        }
        

        // // redirect('login/'.$m);
        
    }

    /**
     * Verify remote licence on mc.sifpos.ao and set a flash error if mismatch/expired.
     */
    private function verify_remote_license()
    {
        // Obter NIF e valores locais direto da BD (evita valores mutados em runtime)
        $nif = '';
        $local_lic = '';
        $local_exp_raw = '';
        // Prefer `tec_settings` (used across the app); fallback to `settings` if absent
        $q = $this->db->get('tec_settings');
        if (!$q || $q->num_rows() == 0) {
            $q = $this->db->get('settings');
        }
        if ($q && $q->num_rows() > 0) {
            $s = $q->row();
            $nif = isset($s->TaxRegistrationNumber) ? trim($s->TaxRegistrationNumber) : (isset($s->tax_registration_number) ? trim($s->tax_registration_number) : '');
            $local_lic = isset($s->licence) ? trim($s->licence) : (isset($s->licence_key) ? trim($s->licence_key) : '');
            // Ensure local_exp_raw matches tec_settings.expired_month when tec_settings exists
            $local_exp_raw = isset($s->expired_month) ? $s->expired_month : (isset($s->expired) ? $s->expired : '');
        }
        if (empty($nif)) {
            return;
        }
        // Decodificar expired_month local se estiver em base64
        $local_exp = @base64_decode($local_exp_raw);
        if ($local_exp === false || $local_exp === '') {
            $local_exp = $local_exp_raw;
        }

        // Chamada ao servidor remoto: busca pelo NIF e devolve o último registo (ORDER BY desc LIMIT 1)
        // Use GET to avoid remote CSRF protections rejecting POST requests
        $url = 'https://mc.sifpos.ao/api/get_license_by_nif?TaxRegistrationNumber=' . urlencode($nif);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Accept: application/json',
            'User-Agent: sifpos-local/1.0'
        ]);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_TIMEOUT, 8);
        $resp = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        $log_file = APPPATH . '../logs/license_checks.log';
        $cache_file = APPPATH . 'cache/license_cache.json';
        $now = date('Y-m-d H:i:s');
        $remote_snippet = substr($resp, 0, 1000);
        // grava resposta completa para debugging (uma linha)
        $safe_resp = is_string($resp) ? str_replace("\n", ' ', $resp) : json_encode($resp);
        @file_put_contents($log_file, "[$now] NIF={$nif} HTTP={$http_code} RAW=" . $safe_resp . "\n", FILE_APPEND|LOCK_EX);
        
        if (!$resp || $http_code != 200) {
            $entry = "[$now] NIF={$nif} IP=" . $this->input->ip_address() . " - remote_unreachable http_code={$http_code} resp_snippet=" . str_replace("\n", ' ', $remote_snippet) . "\n";
            @file_put_contents($log_file, $entry, FILE_APPEND|LOCK_EX);
            
            // Sem internet: usar cache da última verificação bem-sucedida
            if (file_exists($cache_file)) {
                $cached = @file_get_contents($cache_file);
                if ($cached) {
                    $cache_data = json_decode($cached, true);
                    if ($cache_data && isset($cache_data['data']) && isset($cache_data['timestamp'])) {
                        // Verificar se o cache não é muito antigo (máximo 7 dias)
                        $cache_age = time() - $cache_data['timestamp'];
                        if ($cache_age <= (7 * 24 * 60 * 60)) {
                            $entry = "[$now] NIF={$nif} IP=" . $this->input->ip_address() . " - using_cache age=" . round($cache_age/3600) . "h\n";
                            @file_put_contents($log_file, $entry, FILE_APPEND|LOCK_EX);
                            // Usar dados do cache como se fosse resposta do servidor
                            $resp = json_encode($cache_data['data']);
                            $http_code = 200;
                            $data = $cache_data['data'];
                        } else {
                            $entry = "[$now] NIF={$nif} IP=" . $this->input->ip_address() . " - cache_expired age=" . round($cache_age/86400) . " days\n";
                            @file_put_contents($log_file, $entry, FILE_APPEND|LOCK_EX);
                            return true; // Cache expirado, permitir login
                        }
                    } else {
                        return true; // Cache inválido, permitir login
                    }
                } else {
                    return true; // Sem cache, permitir login
                }
            } else {
                // Não foi possível verificar remotamente e sem cache — permitimos login
                return true;
            }
        } else {
            // Resposta bem-sucedida: salvar no cache
            $data = json_decode($resp, true);
            if ($data) {
                $cache_content = json_encode([
                    'timestamp' => time(),
                    'nif' => $nif,
                    'data' => $data
                ]);
                @file_put_contents($cache_file, $cache_content, LOCK_EX);
            }
        }

        if (!isset($data)) {
            $data = json_decode($resp, true);
        }
        if (!$data) return;

        // Suporta resposta directa com object/array ou com chave 'tec_licences' ou 'data'
        $lic_record = null;
        if (isset($data['tec_licences']) && is_array($data['tec_licences'])) {
            // assume que vem uma lista, pega o primeiro (já ordenado pelo servidor)
            $lic_record = reset($data['tec_licences']);
        } elseif (isset($data['data']) && is_array($data['data'])) {
            // 'data' pode ser um registo associativo (com campos) ou uma lista.
            if (isset($data['data']['licence']) || isset($data['data']['expired_month'])) {
                $lic_record = $data['data'];
            } else {
                $first = reset($data['data']);
                if (is_array($first)) $lic_record = $first;
            }
        } elseif (is_array($data)) {
            // se for array associativo com campos directamente
            if (isset($data['licence']) || isset($data['expired_month'])) {
                $lic_record = $data;
            } else {
                // se for lista, pega primeiro elemento
                $first = reset($data);
                if (is_array($first)) $lic_record = $first;
            }
        }

        if (!$lic_record || !is_array($lic_record)) {
            $entry = "[$now] NIF={$nif} IP=" . $this->input->ip_address() . " - no_record_found resp_snippet=" . str_replace("\n", ' ', $remote_snippet) . "\n";
            @file_put_contents($log_file, $entry, FILE_APPEND|LOCK_EX);
            // Sem registo remoto considera-se inválida
            $this->session->set_flashdata('error', 'A sua licença expirou. Por favor adquira uma licença.');
            return false;
        }

        // Campos possíveis
        $remote_lic = isset($lic_record['licence']) ? trim($lic_record['licence']) : (isset($lic_record['Licence']) ? trim($lic_record['Licence']) : '');
        $remote_exp = isset($lic_record['expired_month']) ? trim($lic_record['expired_month']) : (isset($lic_record['expired']) ? trim($lic_record['expired']) : '');
        // Se o remoto retorna expired_month codificado em base64, decodificar para comparar com local
        $decoded_remote_exp = @base64_decode($remote_exp);
        if ($decoded_remote_exp !== false && preg_match('/^\d{4}-\d{2}-\d{2}/', $decoded_remote_exp)) {
            $remote_exp_comp = $decoded_remote_exp;
        } else {
            $remote_exp_comp = $remote_exp;
        }
        // Normalizar licenças para comparação
        $local_lic_comp = is_string($local_lic) ? trim($local_lic) : '';
        $remote_lic_comp = is_string($remote_lic) ? trim($remote_lic) : '';

        if ($remote_lic === '' || $remote_exp === '') {
            $entry = "[$now] NIF={$nif} IP=" . $this->input->ip_address() . " - incomplete_fields remote_lic_empty_or_exp_empty resp_snippet=" . str_replace("\n", ' ', $remote_snippet) . "\n";
            @file_put_contents($log_file, $entry, FILE_APPEND|LOCK_EX);
            $this->session->set_flashdata('error', 'A sua licença expirou. Por favor adquira uma licença.');
            return false;
        }

        // Comparar licença e data de expiração
        if ($remote_lic_comp !== $local_lic_comp || $remote_exp_comp !== trim($local_exp)) {
            $entry = "[$now] NIF={$nif} IP=" . $this->input->ip_address() . " - mismatch local_lic={$local_lic_comp} remote_lic={$remote_lic_comp} local_exp=" . trim($local_exp) . " remote_exp={$remote_exp} (decoded={$remote_exp_comp})\n";
            @file_put_contents($log_file, $entry, FILE_APPEND|LOCK_EX);
            // Persist a short admin-visible alert (so admins see it in the header)
            $alert_file = APPPATH . '../logs/license_alerts.log';
            $alert_msg = "[{$now}] Sua licença não coincide com o registo no servidor SIF-POS para NIF={$nif}.";
            @file_put_contents($alert_file, $alert_msg . "\n", FILE_APPEND|LOCK_EX);
            // Não sincronizar automaticamente: bloquear login quando houver mismatch
            $this->session->set_flashdata('error', '<strong>LICENÇA INVÁLIDA!</strong><br>Sua licença não coincide com o registo no SIF-POS.<br>NIF: ' . $nif . '<br>Por favor contacte o suporte para validar a sua licença, 923230094.');
            return false;
        }

        // Verificar se a data de expiração remota (decodificada) é maior que hoje
        if (preg_match('/^\d{4}-\d{2}-\d{2}/', $remote_exp_comp)) {
            $today = date('Y-m-d');
            if ($remote_exp_comp <= $today) {
                $entry = "[$now] NIF={$nif} IP=" . $this->input->ip_address() . " - expired remote_exp_decoded={$remote_exp_comp} today={$today}\n";
                @file_put_contents($log_file, $entry, FILE_APPEND|LOCK_EX);
                $alert_file = APPPATH . '../logs/license_alerts.log';
                $alert_msg = "[{$now}] A sua licença expirou em {$remote_exp_comp}. Por favor adquira uma nova licença.";
                @file_put_contents($alert_file, $alert_msg . "\n", FILE_APPEND|LOCK_EX);
                $this->session->set_flashdata('error', '<strong>LICENÇA EXPIRADA!</strong><br>Sua licença expirou em: ' . $remote_exp_comp . '<br>NIF: ' . $nif . '<br>Por favor adquira uma nova licença.');
                return false;
            }
        }

        // Tudo OK
        $entry = "[$now] NIF={$nif} IP=" . $this->input->ip_address() . " - valid remote_lic={$remote_lic} remote_exp={$remote_exp}\n";
        @file_put_contents($log_file, $entry, FILE_APPEND|LOCK_EX);
        return true;
    }

    function change_password() {
        if (!$this->ion_auth->logged_in()) {
            redirect('login');
        }
        $this->form_validation->set_rules('old_password', lang('old_password'), 'required');
        $this->form_validation->set_rules('new_password', lang('new_password'), 'required|max_length[25]');
        $this->form_validation->set_rules('new_password_confirm', lang('confirm_password'), 'required|matches[new_password]');

        $user = $this->ion_auth->user()->row();

        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata('error', validation_errors());
            redirect('auth/profile/'.$user->id.'/#cpassword');
        } else {
            if(DEMO) {
                $this->session->set_flashdata('error', lang('disabled_in_demo'));
                redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
            }

            $identity = $this->session->userdata($this->config->item('identity', 'ion_auth'));

            $change = $this->ion_auth->change_password($identity, $this->input->post('old_password'), $this->input->post('new_password'));

            if ($change) {
                $this->session->set_flashdata('message', $this->ion_auth->messages());
                $this->logout();
            } else {
                $this->session->set_flashdata('error', $this->ion_auth->errors());
                redirect('auth/profile/'.$user->id.'/#cpassword');
            }
        }
    }

    function forgot_password() {
        $this->form_validation->set_rules('forgot_email', lang('email_address'), 'required|valid_email');

        if ($this->form_validation->run() == false) {
            $error = validation_errors() ? validation_errors() : $this->session->flashdata('error');
            $this->session->set_flashdata('error', $error);
            redirect("login#forgot_password");
        } else {

            $identity = $this->ion_auth->where('email', strtolower($this->input->post('forgot_email')))->users()->row();
            if (empty($identity)) {
                $this->ion_auth->set_message('forgot_password_email_not_found');
                $this->session->set_flashdata('error', $this->ion_auth->messages());
                redirect("login#forgot_password");
            }

            $forgotten = $this->ion_auth->forgotten_password($identity->email);

            if ($forgotten) {
                $this->session->set_flashdata('message', $this->ion_auth->messages());
                redirect("login#forgot_password");
            } else {
                $this->session->set_flashdata('error', $this->ion_auth->errors());
                redirect("login#forgot_password");
            }
        }
    }

    public function reset_password($code = NULL) {
        if (!$code) {
            show_404();
        }

        $user = $this->ion_auth->forgotten_password_check($code);

        if ($user) {

            $this->form_validation->set_rules('new', lang('password'), 'required|min_length[8]|max_length[25]|matches[new_confirm]');
            $this->form_validation->set_rules('new_confirm', lang('confirm_password'), 'required');

            if ($this->form_validation->run() == false) {

                $this->data['error'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('error');
                $this->data['message'] = $this->session->flashdata('message');
                $this->data['title'] = lang('reset_password');
                $this->data['min_password_length'] = $this->config->item('min_password_length', 'ion_auth');
                $this->data['new_password'] = array(
                    'name' => 'new',
                    'id' => 'new',
                    'type' => 'password',
                    'class' => 'form-control',
                    'pattern' => '^.{8}.*$',
                    );
                $this->data['new_password_confirm'] = array(
                    'name' => 'new_confirm',
                    'id' => 'new_confirm',
                    'type' => 'password',
                    'class' => 'form-control',
                    'pattern' => '^.{8}.*$',
                    );
                $this->data['user_id'] = array(
                    'name' => 'user_id',
                    'id' => 'user_id',
                    'type' => 'hidden',
                    'value' => $user->id,
                    );
                $this->data['csrf'] = $this->_get_csrf_nonce();
                $this->data['code'] = $code;
                $this->data['identity_label'] = $user->email;
                $this->data['page_title'] = lang('reset_password');
                $this->load->view($this->theme.'auth/reset_password', $this->data);
            } else {
                if ($this->_valid_csrf_nonce() === FALSE || $user->id != $this->input->post('user_id')) {

                    $this->ion_auth->clear_forgotten_password_code($code);
                    show_error(lang('error_csrf'));

                } else {
                    $identity = $user->email;

                    $change = $this->ion_auth->reset_password($identity, $this->input->post('new'));

                    if ($change) {
                        $this->session->set_flashdata('message', $this->ion_auth->messages());
                        redirect('login');
                    } else {
                        $this->session->set_flashdata('error', $this->ion_auth->errors());
                        redirect('auth/reset_password/' . $code);
                    }
                }
            }
        } else {
            $this->session->set_flashdata('error', $this->ion_auth->errors());
            redirect("login#forgot_password");
        }
    }

    function activate($id, $code = false) {

        if ($code !== false) {
            $activation = $this->ion_auth->activate($id, $code);
        } else if ($this->Admin) {
            $activation = $this->ion_auth->activate($id);
        }

        if ($activation) {
            $this->session->set_flashdata('message', $this->ion_auth->messages());
            if ($this->Admin) {
              redirect($_SERVER["HTTP_REFERER"]);
          } else {
              redirect("auth/login");
          }
      } else {
        $this->session->set_flashdata('error', $this->ion_auth->errors());
        redirect("forgot_password");
    }
}

function deactivate($id = NULL) {
    if(!$this->Admin) {
        $this->session->set_flashdata('warning', lang("access_denied"));
        redirect($_SERVER["HTTP_REFERER"]);
    }
    $id = $this->config->item('use_mongodb', 'ion_auth') ? (string) $id : (int) $id;
    $this->form_validation->set_rules('confirm', lang("confirm"), 'required');

    if ($this->form_validation->run() == FALSE) {
        if($this->input->post('deactivate')) {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER["HTTP_REFERER"]);
        } else {
            $this->data['csrf'] = $this->_get_csrf_nonce();
            $this->data['user'] = $this->ion_auth->user($id)->row();
            $this->data['modal_js'] = $this->site->modal_js();
            $this->load->view($this->theme.'auth/deactivate_user', $this->data);
        }
    } else {

        if ($this->input->post('confirm') == 'yes') {
            if ($id != $this->input->post('id')) {
                show_error(lang('error_csrf'));
            }

            if ($this->ion_auth->logged_in() && $this->Admin) {
                $this->ion_auth->deactivate($id);
                $this->session->set_flashdata('message', $this->ion_auth->messages());
            }
        }

        redirect($_SERVER["HTTP_REFERER"]);
    }
}

function create_user() {
    if (!$this->Admin) {
        $this->session->set_flashdata('warning', lang("access_denied"));
        redirect($_SERVER["HTTP_REFERER"]);
    }

    $this->data['title'] = lang('add_user');
    $this->form_validation->set_rules('username', lang("username"), 'trim|is_unique[users.username]');
    $this->form_validation->set_rules('email', lang("email"), 'trim|is_unique[users.email]');

    if ($this->form_validation->run() == true) {

        $username = strtolower($this->input->post('username'));
        $email = strtolower($this->input->post('email'));
        $password = $this->input->post('password');
        $notify = $this->input->post('notify');
        $additional_data = array(
            'first_name' => $this->input->post('first_name'),
            'last_name' => $this->input->post('last_name'),
            'phone' => $this->input->post('phone'),
            'gender' => $this->input->post('gender'),
            'box_closure' => $this->input->post('box_closure') ? $this->input->post('box_closure') : 0,
            'unti_value_discount' => $this->input->post('unti_value_discount') ? $this->input->post('unti_value_discount') : 0,
            'settings' => $this->input->post('settings') ? $this->input->post('settings') : 0,
            'reports' => $this->input->post('reports') ? $this->input->post('reports') : 0,
            'group_id' => $this->input->post('group') ? $this->input->post('group') : '2',
        );
        $active = $this->input->post('status');

    }
    if ($this->form_validation->run() == true && $this->ion_auth->register($username, $password, $email, $additional_data, $active, $notify)) {

        $this->session->set_flashdata('message', $this->ion_auth->messages());
        redirect("auth/users");
    } else {

        $this->data['error'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('error')));
        $this->data['groups'] = $this->ion_auth->groups()->result_array();
        $this->data['page_title'] = lang('add_user');
        $bc = array(array('link' => site_url('users'), 'page' => lang('users')), array('link' => '#', 'page' => lang('add_user')));
        $meta = array('page_title' => lang('add_user'), 'bc' => $bc);
        $this->page_construct('auth/create_user', $this->data, $meta);
    }
}

function edit_user($id = NULL) {
    if ($this->input->post('id')) {
        $id = $this->input->post('id');
    }
    $this->data['title'] = lang("edit_user");

    if (!$this->loggedIn || !$this->Admin && $id != $this->session->userdata('user_id')) {
        $this->session->set_flashdata('warning', lang("access_denied"));
        redirect($_SERVER["HTTP_REFERER"]);
    }

    $user = $this->ion_auth->user($id)->row();

    if($user->username != $this->input->post('username')) {
        $this->form_validation->set_rules('username', lang("username"), 'trim|is_unique[users.username]');
    }
    if($user->email != $this->input->post('email')) {
        $this->form_validation->set_rules('email', lang("email"), 'trim|is_unique[users.email]');
    }

    if ($this->form_validation->run() === TRUE) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if ($this->Admin) {
            if($id == $this->session->userdata('user_id')) {
                $data = array(
                    'first_name' => $this->input->post('first_name'),
                    'last_name' => $this->input->post('last_name'),
                    'phone' => $this->input->post('phone'),
                    'gender' => $this->input->post('gender'),
                    'box_closure' => $this->input->post('box_closure') ? $this->input->post('box_closure') : 0,
                    'unti_value_discount' => $this->input->post('unti_value_discount') ? $this->input->post('unti_value_discount') : 0,
                    'settings' => $this->input->post('settings') ? $this->input->post('settings') : 0,
                    'reports' => $this->input->post('reports') ? $this->input->post('reports') : 0,
                    );
            } else {
                $data = array(
                    'first_name' => $this->input->post('first_name'),
                    'last_name' => $this->input->post('last_name'),
                    'username' => $this->input->post('username'),
                    'email' => $this->input->post('email'),
                    'phone' => $this->input->post('phone'),
                    'gender' => $this->input->post('gender'),
                    'active' => $this->input->post('status'),
                    'group_id' => $this->input->post('group'),
                    'box_closure' => $this->input->post('box_closure') ? $this->input->post('box_closure') : 0,
                    'unti_value_discount' => $this->input->post('unti_value_discount') ? $this->input->post('unti_value_discount') : 0,
                    'settings' => $this->input->post('settings') ? $this->input->post('settings') : 0,
                    'reports' => $this->input->post('reports') ? $this->input->post('reports') : 0,
                    );
            }
        } else {
            $data = array(
                'first_name' => $this->input->post('first_name'),
                'last_name' => $this->input->post('last_name'),
                'phone' => $this->input->post('phone'),
                'gender' => $this->input->post('gender'),
                'box_closure' => $this->input->post('box_closure') ? $this->input->post('box_closure') : 0,
                'unti_value_discount' => $this->input->post('unti_value_discount') ? $this->input->post('unti_value_discount') : 0,
                'settings' => $this->input->post('settings') ? $this->input->post('settings') : 0,
                'reports' => $this->input->post('reports') ? $this->input->post('reports') : 0,
                );
        }

        if ($this->Admin) {
            if ($this->input->post('password')) {
                $this->form_validation->set_rules('password', lang('edit_user_validation_password_label'), 'required[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
                $this->form_validation->set_rules('password_confirm', lang('edit_user_validation_password_confirm_label'), 'required');

                $data['password'] = $this->input->post('password');
            }
        }
            //$this->sma->print_arrays($data);

    }
    if ($this->form_validation->run() === TRUE && $this->ion_auth->update($user->id, $data)) {
        $this->session->set_flashdata('message', lang('user_updated'));
        redirect("auth/profile/" . $id);
    }
    else {
        $this->session->set_flashdata('error', validation_errors());
        redirect($_SERVER["HTTP_REFERER"]);
    }
}


function _get_csrf_nonce() {
    $this->load->helper('string');
    $key = random_string('alnum', 8);
    $value = random_string('alnum', 20);
    $this->session->set_flashdata('csrfkey', $key);
    $this->session->set_flashdata('csrfvalue', $value);

    return array($key => $value);
}

function _valid_csrf_nonce() {
    if ($this->input->post($this->session->flashdata('csrfkey')) !== FALSE &&
    $this->input->post($this->session->flashdata('csrfkey')) == $this->session->flashdata('csrfvalue')) {
        return TRUE;
    } else {
        return FALSE;
    }
}

function _render_page($view, $data = null, $render = false) {

    $this->viewdata = (empty($data)) ? $this->data : $data;
    $view_html = $this->load->view('header', $this->viewdata, $render);
    $view_html .= $this->load->view($view, $this->viewdata, $render);
    $view_html = $this->load->view('footer', $this->viewdata, $render);

    if (!$render)
        return $view_html;
}

    function delete($id = NULL) {
        if(DEMO) {
            $this->session->set_flashdata('error', lang('disabled_in_demo'));
            redirect(isset($_SERVER["HTTP_REFERER"]) ? $_SERVER["HTTP_REFERER"] : 'welcome');
        }
        if (!$this->Admin || $id == $this->session->userdata('user_id')) {
            $this->session->set_flashdata('warning', lang("access_denied"));
            redirect($_SERVER["HTTP_REFERER"]);
        }

        if ($this->input->get('id')) {
            $id = $this->input->get('id');
        }

        if ($this->auth_model->delete_user($id)) {
            $this->session->set_flashdata('message', lang('user_deleted'));
            redirect($_SERVER["HTTP_REFERER"]);
        }
    }

    function cancel_password(){
        $this->session->unset_userdata("change_password_status");
        echo json_encode(array("status"=>"ok"));
    }

    function change_password_first(){
        $this->session->unset_userdata("change_password_status");
        $this->load->helper("database_helper");
        $new_password = $this->input->post("new_password");
        $user = get_row("tec_users",array("id"=>$this->session->userdata("user_id")));
        $this->load->model("auth_model");
        $hashed_new_password = $this->auth_model->hash_password($new_password, $user["salt"]);
        update_row("tec_users",array("password"=>$hashed_new_password),array("id"=>$this->session->userdata("user_id")));
        echo json_encode(array("status"=>"ok"));
    }

}
